% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_pvalues.R
\name{adjust_pvalues}
\alias{adjust_pvalues}
\title{Adjust p-values and filter gene-SNP pairs based on the adjusted p-values.}
\usage{
adjust_pvalues(result, pAdjustMethod = "bonferroni", pAdjustThreshold = 0.05)
}
\arguments{
\item{result}{A data frame that contains information of gene-SNP pairs.}

\item{pAdjustMethod}{Method for p-value adjustment. One of "bonferroni",
"holm", "hochberg", "hommel" or "BH". The default option is "bonferroni".}

\item{pAdjustThreshold}{Only gene-SNP pairs with adjusted p-values meeting
the threshold will be displayed. Default by 0.05.}
}
\value{
A data frame with adjusted p-values, filtered by threshold,
containing information on gene-SNP pairs.
}
\description{
Adjust p-values and filter gene-SNP pairs based on the adjusted p-values.
}
\examples{
example_data <- data.frame(
  gene = c("Gene1", "Gene2", "Gene3", "Gene4"),
  SNP = c("SNP1", "SNP2", "SNP3", "SNP4"),
  pvalue = c(0.001, 0.04, 0.03, 0.0005))
pAdjustMethod <- "BH"
pAdjustThreshold <- 0.05
adjusted_result <- adjust_pvalues(example_data, pAdjustMethod,
pAdjustThreshold)
}
