% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSNPList-callQTL.R
\name{checkSNPList}
\alias{checkSNPList}
\title{Validate SNP IDs in the input genotype matrix.}
\usage{
checkSNPList(snpList, snp_mart = NULL, snpDataset = "hsapiens_snp")
}
\arguments{
\item{snpList}{A list of SNPs IDs.}

\item{snp_mart}{An object of class Mart representing the BioMart SNP
database to connect to. If provided, this should be a Mart object obtained
by calling \code{useEnsembl()}, which allows specifying a mirror in case of
connection issues. If \code{NULL}, the function will create and use a Mart
object pointing to the Ensembl SNP BioMart, using the specified
\code{snpDataset} and a default mirror.}

\item{snpDataset}{A character string specifying the SNP dataset to use from
Ensembl. Default is \code{hsapiens_snp} for human SNPs.}
}
\value{
A data frame containing the genomic locations of the valid SNPs.
}
\description{
Validate SNP IDs in the input genotype matrix.
}
\examples{
data(testSNP2)
snpList <- rownames(testSNP2)
snpDataset <- 'hsapiens_snp'
snps_loc <- checkSNPList(snpList = snpList,
                        snpDataset = snpDataset)
}
