% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterGeneSNP.R
\name{filterGeneSNP}
\alias{filterGeneSNP}
\title{Filter gene expression and genotype matrices by cell percentage thresholds.}
\usage{
filterGeneSNP(
  eQTLObject,
  snpNumOfCellsPercent = 10,
  expressionMin = 0,
  expressionNumOfCellsPercent = 10
)
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject}.}

\item{snpNumOfCellsPercent}{Numeric. Minimum percentage of cells required
for each SNP genotype (e.g., AA, AG, and GG). Only SNPs where each genotype
occurs in at least this proportion of cells are retained. Default is 10.}

\item{expressionMin}{Numeric. Expression threshold used in combination with
\code{expressionNumOfCellsPercent} to filter lowly expressed genes.
Default is 0.}

\item{expressionNumOfCellsPercent}{Numeric. Minimum percentage of cells in
which a gene's expression must exceed \code{expressionMin} for the gene to
be retained. Default is 10.}
}
\value{
An updated \code{eQTLObject} with filtered gene expression and SNP
matrices.
}
\description{
Filter gene expression and genotype matrices by cell percentage thresholds.
}
\examples{
data(testSNP)
data(testGene)
eqtl <- createQTLObject(snpMatrix = testSNP, genedata = testGene)
eqtl <- normalizeGene(eqtl)
eqtl <- filterGeneSNP(eqtl,
  snpNumOfCellsPercent = 2,
  expressionMin = 0,
  expressionNumOfCellsPercent = 2)
}
