% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_id-utils.R
\name{get_cell_groups}
\alias{get_cell_groups}
\title{Retrieve Cells by SNP Value}
\usage{
get_cell_groups(snpMatrix, SNPid, biClassify)
}
\arguments{
\item{snpMatrix}{A genotype matrix where each row is a snp and each column
is a cell. Encoding should be 0, 1, 2, 3.}

\item{SNPid}{A character string or numeric index representing the specific
SNP of interest in the SNP matrix.}

\item{biClassify}{Logical; whether to convert genotype encoding in snpMatrix
to 0, 1, and 2. \code{TRUE} indicates conversion; \code{FALSE} indicates no
conversion (default).}
}
\value{
A list of character vectors. Each vector contains the names of cells
(i.e., column names of \code{snpMatrix}) corresponding to a specific
genotype value at the given SNP.
}
\description{
This function extracts the names of cells from a SNP matrix that correspond
to a specified value for a given SNP.
}
\examples{
data(testSNP)
biClassify <- FALSE
get_cell_groups(testSNP, "1:632445", biClassify)
}
