% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_by_id-utils.R
\name{get_counts}
\alias{get_counts}
\title{Extract Counts from an Expression Matrix}
\usage{
get_counts(expressionMatrix, Geneid, cells)
}
\arguments{
\item{expressionMatrix}{A numeric matrix of gene expression counts,
with genes as rows and cells as columns.}

\item{Geneid}{A character string or numeric index representing the specific
gene of interest in \code{expressionMatrix}.}

\item{cells}{A character vector of cell names (column names of
\code{expressionMatrix}) from which to extract counts for the specified gene.}
}
\value{
A numeric vector containing the expression counts of the specified
gene in the selected cells.
}
\description{
This function retrieves expression counts for a specified gene from an
expression matrix, based on the provided list of cells.
}
\examples{
data(testGene)
get_counts(testGene, "CNN2",
          c("CGGCAGTGTAGCCCTG", "GGAGGATTCCCGTTCA"))
}
