% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linearModel-utils.R
\name{linearModel}
\alias{linearModel}
\title{Fit Linear Model for eQTL Mapping}
\usage{
linearModel(
  eQTLObject,
  geneIDs,
  snpIDs,
  biClassify = FALSE,
  pAdjustMethod = "bonferroni",
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.1
)
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject}.}

\item{geneIDs}{Character vector of gene IDs to include in the model fitting.}

\item{snpIDs}{Character vector of SNP IDs to include in the model fitting.}

\item{biClassify}{Logical; whether to convert genotype encoding in snpMatrix
to 0, 1, and 2. \code{TRUE} indicates conversion; \code{FALSE} indicates no
conversion (default).}

\item{pAdjustMethod}{Method used for multiple testing correction. One of
\code{"bonferroni"}, \code{"holm"}, \code{"hochberg"}, \code{"hommel"}, or
\code{"BH"}. Default is \code{"bonferroni"}.}

\item{pAdjustThreshold}{Only gene-SNP pairs with adjusted p-values below
the threshold will be retained. Default is 0.05.}

\item{logfcThreshold}{The minimum beta coefficient (effect size) required
to report a gene-SNP pair as an eQTL.}
}
\value{
A data frame of gene–SNP pairs that pass the filtering criteria,
including beta coefficients, p-values, adjusted p-values, and group labels.
}
\description{
This function performs linear regression to identify gene–SNP associations
based on single-cell expression and genotype data stored in an
\code{eQTLObject}.
}
\examples{
data(testEQTL)
Gene <- rownames(slot(testEQTL, "filterData")$expMat)
SNP <- rownames(slot(testEQTL, "filterData")$snpMat)
linearResult <- linearModel(
  eQTLObject = testEQTL,
  geneIDs = Gene,
  snpIDs = SNP,
  biClassify = FALSE,
  pAdjustMethod = "bonferroni",
  pAdjustThreshold = 0.05,
  logfcThreshold = 0.025)
}
