% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizeQTL.R
\name{visualizeQTL}
\alias{visualizeQTL}
\title{Visualize eQTL results by gene-SNP pair across groups}
\usage{
visualizeQTL(
  eQTLObject,
  SNPid,
  Geneid,
  groupName = NULL,
  plottype = "QTLplot",
  removeoutlier = FALSE
)
}
\arguments{
\item{eQTLObject}{An S4 object of class \code{eQTLObject}.}

\item{SNPid}{ID of SNP.}

\item{Geneid}{ID of Gene.}

\item{groupName}{A \code{character} vector specifying one or more cell group
names to include in the plot.}

\item{plottype}{A \code{character} string specifying the type of plot to
generate. Must be one of \code{"QTLplot"}, \code{"violin"},
\code{"boxplot"}, or \code{"histplot"}.}

\item{removeoutlier}{Logical; whether to identify and remove outliers.
Default is \code{FALSE}.}
}
\value{
list
}
\description{
Visualize eQTL results by gene-SNP pair across groups
}
\examples{
data(testEQTL)
## We have to call the eQTLs firstly using `callQTL()`.
eqtl <- callQTL(eQTLObject = testEQTL, useModel = "linear")
visualizeQTL(eQTLObject = eqtl,
SNPid = "1:632647",
Geneid = "RPS27",
groupName = NULL,
plottype = "QTLplot",
removeoutlier = FALSE)
}
