% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sctkQCUtils.R
\name{getSceParams}
\alias{getSceParams}
\title{Extract QC parameters from the SingleCellExperiment object}
\usage{
getSceParams(
  inSCE,
  skip = c("runScrublet", "runDecontX", "runBarcodeRanksMetaOutput", "genesets",
    "runSoupX"),
  ignore = c("algorithms", "estimates", "contamination", "z", "sample", "rank",
    "BPPARAM", "batch", "geneSetCollection", "barcodeArgs"),
  directory = "./",
  samplename = "",
  writeYAML = TRUE
)
}
\arguments{
\item{inSCE}{A \link[SingleCellExperiment]{SingleCellExperiment} object.}

\item{skip}{Skip extracting the parameters of the provided QC functions.}

\item{ignore}{Skip extracting the content within QC functions.}

\item{directory}{The output directory of the SCTK_runQC.R pipeline.}

\item{samplename}{The sample name of the \link[SingleCellExperiment]{SingleCellExperiment} objects.}

\item{writeYAML}{Whether output yaml file to store parameters. Default if TRUE. If FALSE,
return character object.}
}
\value{
If \code{writeYAML} TRUE, a yaml object will be generated. If FALSE, character object.
}
\description{
Extract QC parameters from the SingleCellExperiment object
}
