% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance.R
\name{plotClusterAbundance}
\alias{plotClusterAbundance}
\title{Plot the differential Abundance}
\usage{
plotClusterAbundance(inSCE, cluster, variable, combinePlot = c("all", "none"))
}
\arguments{
\item{inSCE}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{cluster}{A single \code{character}, specifying the name to store the
cluster label in \code{\link{colData}}.}

\item{variable}{A single \code{character}, specifying the name to store the
phenotype labels in \code{\link{colData}}.}

\item{combinePlot}{Must be either "all" or "none". "all" will combine all 
plots into a single \code{\link[ggplot2]{ggplot}} object. Default 
\code{"all"}.}
}
\value{
When \code{combinePlot = "none"}, a \code{list} with 4 
\code{\link[ggplot2]{ggplot}} objects; when \code{combinePlot = "all"}, a 
single \code{\link[ggplot2]{ggplot}} object with for subplots.
}
\description{
Plot the differential Abundance
}
\details{
This function will visualize the differential abundance in two given
variables, by making bar plots that presents the cell counting and fraction
in different cases.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
plotClusterAbundance(inSCE = mouseBrainSubsetSCE,
                     cluster = "tissue",
                     variable = "level1class")
}
