% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dropletUtils_emptyDrops.R
\name{runEmptyDrops}
\alias{runEmptyDrops}
\title{Identify empty droplets using \link[DropletUtils]{emptyDrops}.}
\usage{
runEmptyDrops(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  lower = 100,
  niters = 10000,
  testAmbient = FALSE,
  ignore = NULL,
  alpha = NULL,
  retain = NULL,
  barcodeArgs = list(),
  BPPARAM = BiocParallel::SerialParam()
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object. Must contain a raw 
counts matrix before empty droplets have been removed.}

\item{sample}{Character vector or colData variable name. Indicates which 
sample each cell belongs to. Default \code{NULL}.}

\item{useAssay}{A string specifying which assay in the SCE to use. Default 
\code{"counts"}}

\item{lower}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{100}.}

\item{niters}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{10000}.}

\item{testAmbient}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{FALSE}.}

\item{ignore}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{NULL}.}

\item{alpha}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{NULL}.}

\item{retain}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{NULL}.}

\item{barcodeArgs}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{list()}.}

\item{BPPARAM}{See \link[DropletUtils]{emptyDrops} for more information. 
Default \code{BiocParallel::SerialParam()}.}
}
\value{
A \linkS4class{SingleCellExperiment} object with the
\link[DropletUtils]{emptyDrops} output table appended to the
\link{colData} slot. The columns include
\code{emptyDrops_total}, \code{emptyDrops_logprob},
\code{emptyDrops_pvalue}, \code{emptyDrops_limited}, \code{emptyDrops_fdr}.
Please refer to the documentation of \link[DropletUtils]{emptyDrops} for
details.
}
\description{
Run \link[DropletUtils]{emptyDrops} on the count matrix in the
provided \linkS4class{SingleCellExperiment} object.
Distinguish between droplets containing cells and ambient RNA in a
droplet-based single-cell RNA sequencing experiment.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- runEmptyDrops(inSCE = sce)
}
\seealso{
\code{\link{runDropletQC}}, \code{\link{plotEmptyDropsResults}},
\code{\link{plotEmptyDropsScatter}}
}
