% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPlotting.R
\name{setSCTKDisplayRow}
\alias{setSCTKDisplayRow}
\title{Indicates which rowData to use for visualization}
\usage{
setSCTKDisplayRow(inSCE, featureDisplayRow)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results. Required.}

\item{featureDisplayRow}{Indicates which column name of rowData to be used for plots.}
}
\value{
A SingleCellExperiment object with the specific column name of rowData
 to be used for plotting stored in metadata.
}
\description{
This function is to be used to specify which
}
\examples{
data(scExample, package="singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- setSCTKDisplayRow(inSCE = sce, featureDisplayRow = "feature_name")
plotSCEViolinAssayData(inSCE = sce, feature = "ENSG00000019582")
}
