% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DownsampleMatrix.R
\name{subDiffEx}
\alias{subDiffEx}
\alias{subDiffExttest}
\alias{subDiffExANOVA}
\title{Passes the output of generateSimulatedData() to differential expression
tests, picking either t-tests or ANOVA for data with only two conditions or
multiple conditions, respectively.}
\usage{
subDiffEx(tempData)

subDiffExttest(countMatrix, class.labels, test.type = "t.equalvar")

subDiffExANOVA(countMatrix, condition)
}
\arguments{
\item{tempData}{Matrix. The output of generateSimulatedData(), where the
first row contains condition labels.}

\item{countMatrix}{Matrix. A simulated counts matrix, sans labels.}

\item{class.labels}{Factor. The condition labels for the simulated cells.
Will be coerced into 1's and 0's.}

\item{test.type}{Type of test to perform. The default is t.equalvar.}

\item{condition}{Factor. The condition labels for the simulated cells.}
}
\value{
subDiffEx(): A vector of fdr-adjusted p-values for all genes.
Nonviable results (such as for genes with 0 counts in a simulated dataset)
are coerced to 1.

subDiffExttest(): A vector of fdr-adjusted p-values for all genes.
Nonviable results (such as for genes with 0 counts in a simulated dataset)
are coerced to 1.

subDiffExANOVA(): A vector of fdr-adjusted p-values for all genes.
Nonviable results (such as for genes with 0 counts in a simulated dataset)
are coerced to 1.
}
\description{
Passes the output of generateSimulatedData() to differential expression
tests, picking either t-tests or ANOVA for data with only two conditions or
multiple conditions, respectively.
}
\section{Functions}{
\itemize{
\item \code{subDiffEx()}: 

\item \code{subDiffExttest()}: Runs t-tests on all genes in a simulated dataset with 2
conditions, and adjusts for FDR.

\item \code{subDiffExANOVA()}: Runs ANOVA on all genes in a simulated dataset with
more than 2 conditions, and adjusts for FDR.

}}
\examples{
data("mouseBrainSubsetSCE")
res <- generateSimulatedData(
         totalReads = 1000, cells=10,
         originalData = assay(mouseBrainSubsetSCE, "counts"),
         realLabels = colData(mouseBrainSubsetSCE)[, "level1class"])
tempSigDiff <- subDiffEx(res)

data("mouseBrainSubsetSCE")
#sort first 100 expressed genes
ord <- rownames(mouseBrainSubsetSCE)[
  order(rowSums(assay(mouseBrainSubsetSCE, "counts")),
        decreasing = TRUE)][seq(100)]
#subset to those first 100 genes
subset <- mouseBrainSubsetSCE[ord, ]
res <- generateSimulatedData(totalReads = 1000, cells=10,
                             originalData = assay(subset, "counts"),
                             realLabels = colData(subset)[, "level1class"])
realLabels <- res[1, ]
output <- res[-1, ]
fdr <- subDiffExttest(output, realLabels)

data("mouseBrainSubsetSCE")
#sort first 100 expressed genes
ord <- rownames(mouseBrainSubsetSCE)[
  order(rowSums(assay(mouseBrainSubsetSCE, "counts")),
        decreasing = TRUE)][seq(100)]
# subset to those first 100 genes
subset <- mouseBrainSubsetSCE[ord, ]
res <- generateSimulatedData(totalReads = 1000, cells=10,
                             originalData = assay(subset, "counts"),
                             realLabels = colData(subset)[, "level2class"])
realLabels <- res[1, ]
output <- res[-1, ]
fdr <- subDiffExANOVA(output, realLabels)

}
