% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankGenesGeneric.R
\name{rankGenes}
\alias{rankGenes}
\alias{rankGenes,matrix-method}
\alias{rankGenes,data.frame-method}
\alias{rankGenes,DGEList-method}
\alias{rankGenes,ExpressionSet-method}
\alias{rankGenes,SummarizedExperiment-method}
\title{Rank genes by the gene expression intensities}
\usage{
rankGenes(expreMatrix, tiesMethod = "min", stableGenes = NULL)

\S4method{rankGenes}{matrix}(expreMatrix, tiesMethod = "min", stableGenes = NULL)

\S4method{rankGenes}{data.frame}(expreMatrix, tiesMethod = "min", stableGenes = NULL)

\S4method{rankGenes}{DGEList}(expreMatrix, tiesMethod = "min", stableGenes = NULL)

\S4method{rankGenes}{ExpressionSet}(expreMatrix, tiesMethod = "min", stableGenes = NULL)

\S4method{rankGenes}{SummarizedExperiment}(expreMatrix, tiesMethod = "min", stableGenes = NULL)
}
\arguments{
\item{expreMatrix}{matrix, data.frame, ExpressionSet, DGEList or
SummarizedExperiment storing gene expression measurements}

\item{tiesMethod}{character, indicating what method to use when dealing with
ties}

\item{stableGenes}{character, containing a list of stable genes to be used to
rank genes using expression of stable genes. This is required when using the
stable genes dependent version of singscore (see details in \code{simpleScore}).
Stable genes for solid cancers (carcinomas) and blood transcriptomes can be
obtained using the \code{getStableGenes} function}
}
\value{
The ranked gene expression matrix that has samples in columns and
genes in rows. Unit normalised ranks are returned if data is ranked using
stable genes
}
\description{
The \code{rankGenes} function is a generic function that can deal
with mutilple types of inputs. Given a matrix of gene expression that has
samples in columns, genes in rows, and values being gene expression
intensity,\code{rankGenes} ranks gene expression intensities in each sample.

It can also work with S4 objects that have gene expression matrix as a
component (i.e ExpressionSet, DGEList,SummarizedExperiment). It calls the
\code{rank} function in the base package which ranks the gene expression
matrix by its absolute expression level. If the input is S4 object of
\code{DGEList, ExpressionSet, or SummarizedExperiment}, it will extract the
gene expression matrix from the object and rank the genes. The default
'tiesMethod' is set to 'min'.
}
\examples{
rankGenes(toy_expr_se) # toy_expr_se is a gene expression dataset

# ExpressionSet object
emat <- SummarizedExperiment::assay(toy_expr_se)
e <- Biobase::ExpressionSet(assayData = as.matrix(emat))
rankGenes(e)

#scoring using the stable version of singscore
rankGenes(e, stableGenes = c('2', '20', '25'))

\dontrun{
#for real cancer or blood datasets, use getStableGenes()
rankGenes(cancer_expr, stableGenes = getStableGenes(5))
rankGenes(blood_expr, stableGenes = getStableGenes(5, type = 'blood'))
}
}
\seealso{
\code{\link{getStableGenes}}, \code{\link{simpleScore}},
\code{\link{rank}}, \link[=ExpressionSet-class]{"ExpressionSet"},
\link[=SummarizedExperiment-class]{"SummarizedExperiment"},
\link[=DGEList-class]{"DGEList"}
}
