% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{draw_volcano_plot}
\alias{draw_volcano_plot}
\title{\emph{k}-mer Enrichment Volcano Plot}
\usage{
draw_volcano_plot(
  kmers,
  motif_kmers,
  motif_rbps,
  significance_threshold = 0.01,
  show_legend = TRUE
)
}
\arguments{
\item{kmers}{data frame with the following columns: kmer,
adj_p_value, enrichment}

\item{motif_kmers}{set of \emph{k}-mers that are associated with
a certain motif,
will be highlighted in volcano plot}

\item{motif_rbps}{name of RNA-binding proteins associated with
highlighted \emph{k}-mers
(character vector of length 1)}

\item{significance_threshold}{p-value threshold for significance,
e.g., \code{0.05} or
\code{0.01}}

\item{show_legend}{whether or not a legend should be shown}
}
\value{
volcano plot
}
\description{
Uses a volcano plot to visualize \emph{k}-mer enrichment.
X-axis is \eqn{\log_2} enrichment value,
y-axis is \eqn{\log_10} significance, i.e., multiple testing
corrected p-value from
Fisher's exact test or Pearson's chi-squared test.
}
\examples{
motif <- get_motif_by_id("951_12324455")
draw_volcano_plot(transite:::kmers_enrichment, get_hexamers(motif[[1]]),
  get_rbps(motif[[1]]))

\dontrun{
foreground_set <- c("UGUGGG", "GUGGGG", "GUGUGG", "UGUGGU")
background_set <- unique(c(foreground_set, c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA",
  "CCACACAC", "CUCAUUGGAG", "ACUUUCCCACA", "CAGGUCAGCA",
  "CCACACCAG", "CCACACAUCAGU", "CACACACUCC", "CAGCCCCCCACAGGCA"
)))

motif <- get_motif_by_id("M178_0.6")
results <- run_kmer_tsma(list(foreground_set), background_set,
                       motifs = motif)
draw_volcano_plot(results[[1]]$motif_kmers_dfs[[1]],
    get_hexamers(motif[[1]]), "test RBP")}

}
\seealso{
Other TSMA functions: 
\code{\link{run_kmer_tsma}()},
\code{\link{run_matrix_tsma}()}

Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{TSMA functions}
\concept{\emph{k}-mer functions}
