% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{generate_kmers}
\alias{generate_kmers}
\title{\emph{k}-mer Counts for Sequence Set}
\usage{
generate_kmers(sequences, k)
}
\arguments{
\item{sequences}{character vector of DNA or RNA sequences}

\item{k}{length of \emph{k}-mer, either \code{6} for hexamers or
\code{7} for heptamers}
}
\value{
Returns a named numeric vector, where the elements are
\emph{k}-mer counts and the
names are DNA \emph{k}-mers.
}
\description{
Counts occurrences of \emph{k}-mers of length \code{k} in the given set of
sequences. Corrects for homopolymeric stretches.
}
\section{Warning}{

\code{generate_kmers} always returns DNA \emph{k}-mers, even if
\code{sequences} contains RNA sequences.
RNA sequences are internally converted to DNA sequences. It is not
allowed to mix DNA and
RNA sequences.
}

\examples{
# count hexamers in set of RNA sequences
rna_sequences <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA",
  "UUAUUUA", "AUCCUUUACA", "UUUUUUU", "UUUCAUCAUU",
  "CCACACAC", "CUCAUUGGAG", "ACUUUGGGACA", "CAGGUCAGCA"
)
hexamer_counts <- generate_kmers(rna_sequences, 6)


# count heptamers in set of DNA sequences
dna_sequences <- c(
  "CAACAGCCTTAATT", "CAGTCAAGACTCC", "CTTTGGGGAAT",
  "TCATTTTATTAAA", "AATTGGTGTCTGGATACTTCCCTGTACAT",
  "ATCAAATTA", "AGAT", "GACACTTAAAGATCCT",
  "TAGCATTAACTTAATG", "ATGGA", "GAAGAGTGCTCA",
  "ATAGAC", "AGTTC", "CCAGTAA",
  "TTATTTA", "ATCCTTTACA", "TTTTTTT", "TTTCATCATT",
  "CCACACAC", "CTCATTGGAG", "ACTTTGGGACA", "CAGGTCAGCA"
)
hexamer_counts <- generate_kmers(dna_sequences, 7)
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{compute_kmer_enrichment}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
