% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indelcator.R
\name{indelcator}
\alias{indelcator}
\alias{indelcator,XString,GRanges-method}
\alias{indelcator,DNAStringSet,GRanges-method}
\alias{indelcator,BSgenome,GRanges-method}
\title{Substitute InDels into one or more sequences}
\usage{
indelcator(x, indels, ...)

\S4method{indelcator}{XString,GRanges}(x, indels, exons, alt_col = "ALT", ol_vars = "fail", ...)

\S4method{indelcator}{DNAStringSet,GRanges}(
  x,
  indels,
  alt_col = "ALT",
  ol_vars = "fail",
  mc.cores = 1,
  verbose = TRUE,
  ...
)

\S4method{indelcator}{BSgenome,GRanges}(
  x,
  indels,
  alt_col = "ALT",
  ol_vars = "fail",
  mc.cores = 1,
  names,
  ...
)
}
\arguments{
\item{x}{Sequence of class XString}

\item{indels}{GRanges object with InDel locations and the alternate allele}

\item{...}{Passed to \link[parallel:mclapply]{parallel::mclapply}}

\item{exons}{GRanges object containing exon structure for \code{x}}

\item{alt_col}{Column containing the alternate allele}

\item{ol_vars}{Error handling for any overlapping variants. See
\link{cleanVariants} for possible values and an explanation}

\item{mc.cores}{Number of cores to use when calling \link[parallel:mclapply]{parallel::mclapply}
internally}

\item{verbose}{logical(1) Print all messages}

\item{names}{passed to \link[BSgenome:getSeq-methods]{BSgenome::getSeq} when x is a BSgenome object}
}
\value{
A DNAStringSet or XString object (See Details)
}
\description{
Modify one or more sequences to include Insertions or Deletions
}
\details{
This is a lower-level function relied on by both \code{\link[=transmogrify]{transmogrify()}} and
\code{\link[=genomogrify]{genomogrify()}}.

Takes an \link[Biostrings:XString-class]{Biostrings::XString} or \link[Biostrings:XStringSet-class]{Biostrings::XStringSet} object and
modifies the sequence to incorporate InDels.
The expected types of data determine the behaviour, with the following
expectations describing how the function will incorporate data\tabular{llll}{
   Input Data Type \tab Exons Required \tab Use Case \tab Returned \cr
   XString \tab Y \tab Modify a Reference Transcriptome \tab XString \cr
   DNAStringSet \tab N \tab Modify a Reference Genome \tab DNAStringSet \cr
   BSgenome \tab N \tab Modify a Reference Genome \tab DNAStringSet \cr
}
}
\examples{
## Start with a DNAStringSet
library(GenomicRanges)
seq <- DNAStringSet(c(seq1 = "AATCTGCGC"))
## Define an Insertion
var <- GRanges("seq1:1")
var$ALT <- "AAA"
seq
indelcator(seq, var)

## To modify a single transcript
library(GenomicFeatures)
ex <- GRanges(c("seq1:1-3:+", "seq1:7-9:+"))
orig <- extractTranscriptSeqs(seq, GRangesList(tx1 = ex))[["tx1"]]
orig
indelcator(orig, var, exons = ex)

}
\seealso{
\code{\link[=transmogrify]{transmogrify()}} \code{\link[=genomogrify]{genomogrify()}}
}
