% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_homer.R
\name{write_homer}
\alias{write_homer}
\title{Export motifs in HOMER format.}
\usage{
write_homer(motifs, file, logodds_threshold = NULL, overwrite = FALSE,
  append = FALSE, threshold = 0.8, threshold.type = c("logodds",
  "logodds.abs", "pvalue"))
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{file}{\code{character(1)} File name.}

\item{logodds_threshold}{Deprecated. If set, \code{\link[=read_homer]{read_homer()}} will behave like
pre-version 1.12.0 of the \code{universalmotif} package for backwards
compatibility (though a warning will be printed).}

\item{overwrite}{\code{logical(1)} Overwrite existing file.}

\item{append}{\code{logical(1)} Add to an existing file.}

\item{threshold}{\code{numeric(1)} Stringency required for HOMER to match a motif.
See \code{\link[=scan_sequences]{scan_sequences()}} for how to use this argument. Can be a single value to
be recycled for all motifs, or a vector of equal length to the number of motifs.}

\item{threshold.type}{\code{character(1)} How the \code{threshold} value should be used
to obtain the final threshold value in the written motif. See \code{\link[=scan_sequences]{scan_sequences()}}
for how to use this.}
}
\value{
\code{NULL}, invisibly.
}
\description{
Convert DNA motifs to HOMER format and write to file.
See \url{http://homer.ucsd.edu/homer/motif/}.
}
\examples{
motif <- create_motif()
write_homer(motif, tempfile())

}
\references{
Heinz S, Benner C, Spann N, Bertolino E, Lin YC, Laslo P, Cheng
JX, Murre C, Singh H, Glass CK (2010). “Simple combinations of
lineage-determining transcription factors prime cis-regulatory
elements required for macrophage and B cell identities.”
\emph{Molecular Cell}, \strong{38}, 576-589.
}
\seealso{
\code{\link[=read_homer]{read_homer()}}

Other write_motifs: 
\code{\link{write_jaspar}()},
\code{\link{write_matrix}()},
\code{\link{write_meme}()},
\code{\link{write_motifs}()},
\code{\link{write_transfac}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{write_motifs}
