% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assignTxID}
\alias{assignTxID}
\alias{assignTxID,GenomicRanges,GenomicRanges-method}
\alias{assignTxID,RangedSummarizedExperiment,GenomicRanges-method}
\alias{assignTxID,GenomicRanges,TxDb-method}
\alias{assignTxID,RangedSummarizedExperiment,TxDb-method}
\title{Annotate ranges with transcript ID.}
\usage{
assignTxID(object, txModels, ...)

\S4method{assignTxID}{GenomicRanges,GenomicRanges}(object, txModels, outputColumn = "txID", swap = NULL)

\S4method{assignTxID}{RangedSummarizedExperiment,GenomicRanges}(object, txModels, ...)

\S4method{assignTxID}{GenomicRanges,TxDb}(
  object,
  txModels,
  outputColumn = "txID",
  swap = NULL,
  upstream = 1000,
  downstream = 0
)

\S4method{assignTxID}{RangedSummarizedExperiment,TxDb}(object, txModels, ...)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Ranges to be annotated.}

\item{txModels}{TxDb or GRanges: Transcript models via a TxDb, or manually
specified as a GRanges.}

\item{...}{additional arguments passed to methods.}

\item{outputColumn}{character: Name of column to hold txID values.}

\item{swap}{character or NULL: If not NULL, use another set of ranges
contained in object to calculate overlaps, for example peaks in the thick
column.}

\item{upstream}{integer: Distance to extend annotated promoter upstream.}

\item{downstream}{integer: Distance to extend annotated promoter downstream.}
}
\value{
object with txID added as a column in rowData (or mcols)
}
\description{
Annotate a set of ranges in a GRanges object with transcript IDs based on
their genic context. All overlapping transcripts are returned. Transcripts
are obtained from a TxDb object, or can manually supplied as a GRanges.
}
\examples{
data(exampleUnidirectional)

# Obtain transcript models from a TxDb-object:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene

# Assign txIDs
assignTxID(exampleUnidirectional,
           txModels=txdb,
           outputColumn='geneID')

# Assign txIDs using only TC peaks:
assignTxID(exampleUnidirectional,
             txModels=txdb,
             outputColumn='geneID',
             swap='thick')
}
\seealso{
Other Annotation functions: 
\code{\link{assignGeneID}()},
\code{\link{assignMissingID}()},
\code{\link{assignTxType}()}
}
\concept{Annotation functions}
