% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bw.R
\name{bwValid}
\alias{bwValid}
\alias{bwValid,BigWigFile-method}
\alias{bwValid,BigWigFileList-method}
\title{Check if BigWig-files are valid.}
\usage{
bwValid(object)

\S4method{bwValid}{BigWigFile}(object)

\S4method{bwValid}{BigWigFileList}(object)
}
\arguments{
\item{object}{BigWigFile or BigWigFileList}
}
\value{
TRUE, if any tests fails an error is raised.
}
\description{
Checks if a BigWigFile or BigWigFileList is composed of readable files with
the proper .bw extension.
}
\examples{
# Use the BigWig-files included with the package:
data('exampleDesign')
bw_plus <- system.file('extdata', exampleDesign$BigWigPlus,
                       package = 'CAGEfightR')

# Create a named BigWigFileList-object with names
bw_plus <- BigWigFileList(bw_plus)
names(bw_plus) <- exampleDesign$Name

# Check a single BigWigFile:
bwValid(bw_plus[[1]])

# Check the entire BigWigFileList:
bwValid(bw_plus)
}
\seealso{
Other BigWig functions: 
\code{\link{bwCommonGenome}()},
\code{\link{bwGenomeCompatibility}()}
}
\concept{BigWig functions}
