% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{checkCTSSs}
\alias{checkCTSSs}
\alias{checkCTSSs,ANY-method}
\alias{checkCTSSs,GRanges-method}
\alias{checkCTSSs,character-method}
\alias{checkCTSSs,GPos-method}
\alias{checkCTSSs,BigWigFile-method}
\title{Helper for checking files containing CTSSs}
\usage{
checkCTSSs(object)

\S4method{checkCTSSs}{ANY}(object)

\S4method{checkCTSSs}{GRanges}(object)

\S4method{checkCTSSs}{character}(object)

\S4method{checkCTSSs}{GPos}(object)

\S4method{checkCTSSs}{BigWigFile}(object)
}
\arguments{
\item{object}{BigWigFile, character, GRanges or GPos: Path to the file
storing CTSSs, or an already improted GRanges/GPos.}
}
\value{
TRUE if CTSSs are correctly  formatted, otherwise a (hopefully)
  informative error is thrown.
}
\description{
Checks whether a file (or GRanges/GPos) contains data formatted in the same
manner as CAGE Transcription Start Sites (CTSSs): Each basepair of the genome
is associated with a single integer count.
}
\note{
In the case that a character is supplied pointing to a file, checkCTSSs
  will not check any extensions, but simply try to read it using
  rtracklayer::import. This means that checkCTSSs can technically analyze
  BED-files, although CAGEfightR can only import CTSSs from BigWig or
  bedGraph files.
}
\examples{
if (.Platform$OS.type != "windows") {
# Load example data
data('exampleDesign')
bw_plus <- system.file('extdata',
                       exampleDesign$BigWigPlus,
                       package = 'CAGEfightR')
bw_plus <- BigWigFileList(bw_plus)

# Check raw file
checkCTSSs(bw_plus[[1]])

# Import first, then check
gr  <- import(bw_plus[[1]])
checkCTSSs(gr)
}
}
