% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster.R
\name{clusterUnidirectionally}
\alias{clusterUnidirectionally}
\alias{clusterUnidirectionally,GRanges-method}
\alias{clusterUnidirectionally,RangedSummarizedExperiment-method}
\alias{clusterUnidirectionally,GPos-method}
\title{Unidirectional Clustering (Tag Clustering) of pooled CTSSs.}
\usage{
clusterUnidirectionally(object, ...)

\S4method{clusterUnidirectionally}{GRanges}(object, pooledCutoff = 0, mergeDist = 20L)

\S4method{clusterUnidirectionally}{RangedSummarizedExperiment}(object, ...)

\S4method{clusterUnidirectionally}{GPos}(object, ...)
}
\arguments{
\item{object}{GRanges or RangedSummarizedExperiment: Basepair-wise pooled
CTSS.}

\item{...}{additional arguments passed to methods.}

\item{pooledCutoff}{numeric: Minimum pooled value to be considered as TC.}

\item{mergeDist}{integer: Merge TCs within this distance.}
}
\value{
GRanges with TPM sum as the score column, and TC peak as the thick
  column.
}
\description{
Finds unidirectional Tag Clusters (TCs) with a pooled TPM above a certain
threshold using a slice-reduce approach. Addtionally calculates the sum and
peak position of the TCs.
}
\examples{
data(exampleCTSSs)

# Calculate pooledTPM, using supplied number of total tags
exampleCTSSs <- calcTPM(exampleCTSSs,
                        inputAssay='counts',
                        outputAssay='TPM',
                        totalTags='totalTags')
exampleCTSSs <- calcPooled(exampleCTSSs, inputAssay='TPM')

# Cluster using defaults: slice-threshold of 0 and reduce-distance of 20
clusterUnidirectionally(exampleCTSSs)

# Use custom thresholds:
clusterUnidirectionally(exampleCTSSs, pooledCutoff=1, mergeDist=25)
}
\seealso{
Other Clustering functions: 
\code{\link{clusterBidirectionally}()},
\code{\link{trimToPeak}()},
\code{\link{trimToPercentiles}()},
\code{\link{tuneTagClustering}()}
}
\concept{Clustering functions}
