% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convertGRanges2GPos}
\alias{convertGRanges2GPos}
\title{Convert GRanges with scores to GPos}
\usage{
convertGRanges2GPos(object)
}
\arguments{
\item{object}{GRanges object with a score column}
}
\value{
GPos with score column
}
\description{
Converts a GRanges to a GPos, correctly expanding the score column. This is
useful is nearby CTSSs with the same count are grouped in the same range (see
example).
}
\examples{
# Example GRanges
gr <- GRanges(Rle(c("chr2", "chr2", "chr3", "chr4")),
              IRanges(start=c(1, 10, 5, 3),
              end=c(5L, 10L, 5L, 4L)),
              strand="+",
              score=c(2, 1, 3, 11))

# Expand to proper GPos / CTSS format:
gp <- convertGRanges2GPos(gr)

# Double check that the total number of counts remains the same
stopifnot(sum(score(gr) * width(gr)) == sum(score(gp)))
}
