% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quantify.R
\name{quantifyGenes}
\alias{quantifyGenes}
\title{Quantify expression of genes}
\usage{
quantifyGenes(object, genes, inputAssay = "counts", sparse = FALSE)
}
\arguments{
\item{object}{RangedSummarizedExperiment: Cluster-level expression values.}

\item{genes}{character: Name of column in rowData holding gene IDs (NAs will
be discarded).}

\item{inputAssay}{character: Name of assay holding values to be quantified,
(usually counts).}

\item{sparse}{logical: If the input is a sparse matrix, TRUE will keep the
output matrix sparse while FALSE will coerce it into a normal matrix.}
}
\value{
RangedSummarizedExperiment with rows corresponding to genes. Location
  of clusters within genes is stored as a GRangesList in rowRanges. seqinfo
  and colData is copied over from object.
}
\description{
Obtain gene-level expression estimates by summing clusters annotated to the
same gene. Unannotated transcripts (NAs) are discarded.
}
\examples{
data(exampleUnidirectional)

# Annotate clusters with geneIDs:
library(TxDb.Mmusculus.UCSC.mm9.knownGene)
txdb <- TxDb.Mmusculus.UCSC.mm9.knownGene
exampleUnidirectional <- assignGeneID(exampleUnidirectional,
                                      geneModels=txdb,
                                      outputColumn='geneID')

# Quantify counts within genes:
quantifyGenes(exampleUnidirectional, genes='geneID', inputAssay='counts')

# For exceptionally large datasets,
# the resulting count matrix can be left sparse:
quantifyGenes(exampleUnidirectional,
              genes='geneID',
              inputAssay='counts',
              sparse=TRUE)
}
\seealso{
Other Quantification functions: 
\code{\link{quantifyCTSSs2}()},
\code{\link{quantifyCTSSs}()},
\code{\link{quantifyClusters}()}
}
\concept{Quantification functions}
