% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{trackClusters}
\alias{trackClusters}
\alias{trackClusters,GRanges-method}
\alias{trackClusters,RangedSummarizedExperiment-method}
\title{Create genome browser track of clusters.}
\usage{
trackClusters(object, ...)

\S4method{trackClusters}{GRanges}(
  object,
  plusColor = "cornflowerblue",
  minusColor = "tomato",
  unstrandedColor = "hotpink",
  ...
)

\S4method{trackClusters}{RangedSummarizedExperiment}(object, ...)
}
\arguments{
\item{object}{GRanges: GRanges with peaks in the thick-column.}

\item{...}{additional arguments passed on to GeneRegionTrack.}

\item{plusColor}{character: Color for plus-strand features.}

\item{minusColor}{character: Color for minus-strand features.}

\item{unstrandedColor}{character: Color for unstranded features.}
}
\value{
GeneRegionTrack-object.
}
\description{
Create a Gviz-track of clusters (unidirectional TCs or bidirectional
enhancers), where cluster strand and peak is indicated.
}
\examples{
library(Gviz)
data(exampleUnidirectional)

# Find some wide unidirectional clusters:
TCs <- subset(exampleUnidirectional, width >= 100)

# Create track
clusters_track <- trackClusters(TCs[1:2,], name='Tag clusters', col=NULL)

# Plot
plotTracks(clusters_track)

# See vignette for examples on how to combine multiple Gviz tracks
}
\seealso{
Other Genome Browser functions: 
\code{\link{trackBalance}()},
\code{\link{trackCTSS}()},
\code{\link{trackLinks}()}
}
\concept{Genome Browser functions}
