% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{trackLinks}
\alias{trackLinks}
\title{Create a genome browser track of links.}
\usage{
trackLinks(object, ...)
}
\arguments{
\item{object}{GInteractions: Links or pairs between clusters.}

\item{...}{additional arguments passed to InteractionTrack via displayPars.}
}
\value{
InteractionTrack-object from the GenomicInteractions package.
}
\description{
Create a Gviz-track of links (e.g. between TSSs and enhancers), where arches connect the different pairs of clusters. The height of arches can be set to scale the strength of the interaction (for example indicating higher correlation). This function is a thin wrapper around the InteractionTrack-class from the GenomicInteractions package. Currently, only scaling arch height by p-value is supported.
}
\examples{
library(InteractionSet)
library(Gviz)
library(GenomicInteractions)

# Links between highly expressed unidirectional clusters
TCs <- subset(exampleUnidirectional, score > 10)
TC_links <- findLinks(TCs, inputAssay="counts", maxDist=10000L)
link_track <- trackLinks(TC_links, name="TSS links", interaction.measure="p.value")

# Plot region
plot_region <- GRanges(seqnames="chr18",
                       ranges = IRanges(start=start(anchors(TC_links[1],
                                                            "first")),
                                        end=end(anchors(TC_links[1],
                                                        "second"))))
# Plot using Gviz
plotTracks(link_track,
           from=start(plot_region),
           to=end(plot_region),
           chromosome = as.character(seqnames(plot_region)))
# See vignette for examples on how to combine multiple Gviz tracks
}
\seealso{
Other Genome Browser functions: 
\code{\link{trackBalance}()},
\code{\link{trackCTSS}()},
\code{\link{trackClusters}()}

Other Spatial functions: 
\code{\link{findLinks}()},
\code{\link{findStretches}()}
}
\concept{Genome Browser functions}
\concept{Spatial functions}
