% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CellCounts.R
\name{CellCounts}
\alias{CellCounts}
\title{Compute Number of Cells Positive for Certain Cytokine Combinations}
\usage{
CellCounts(data, combinations)
}
\arguments{
\item{data}{Either a \code{COMPASSContainer}, or a list of matrices.
Each matrix \code{i} is of dimension \code{N_i} cells (rows) by
\code{K} common markers (columns).}

\item{combinations}{A list of 'combinations', used to denote the
subsets of interest. See the examples for usage.}
}
\description{
Compute the number of cells expressing a particular
combination of markers for each sample.
}
\examples{
set.seed(123)
## generate 10 simulated matrices of flow data
K <- 6 ## number of markers
data <- replicate(10, simplify=FALSE, {
  m <- matrix( rnorm(1E4 * K, 2000, 1000 ), ncol=K )
  m[m < 2500] <- 0
  colnames(m) <- c("IL2", "IL4", "IL6", "Mip1B", "IFNg", "TNFa")
  return(m)
})
names(data) <- sample(letters, 10)
head( data[[1]] )

## generate counts over all available combinations of markers in data
str(CellCounts(data)) ## 64 columns, as all 2^6 combinations expressed

## generate marginal counts
combos <- list(1, 2, 3, 4, 5, 6) ## marginal cell counts
cc <- CellCounts(data, combos)

## a base R way of doing the same thing
f <- function(data) {
  do.call(rbind, lapply(data, function(x) apply(x, 2, function(x) sum(x > 0))))
}
cc2 <- f(data)

## check that they're identical
stopifnot(identical( unname(cc), unname(cc2) ))

## We can also generate cell counts by expressing various combinations
## of markers (names) in the data.

## count cells expressing IL2 or IL4
CellCounts(data, "IL2|IL4")

## count cells expressing IL2, IL4 or IL6
CellCounts(data, "IL2|IL4|IL6")

## counts for each of IL2, IL4, IL6 (marginally)
CellCounts(data, c("IL2", "IL4", "IL6"))

## counts for cells that are IL2 positive and IL4 negative
CellCounts(data, "IL2 & !IL4")

## expressing the same intent with indices
CellCounts(data, list(c(1, -2)))

## all possible combinations
str(CellCounts(data, Combinations(6)))

## can also call on COMPASSContainers
data(COMPASS)
CellCounts(CC, "M1&M2")
}
\seealso{
\code{\link{Combinations}}
}
