% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMeanGamma-2.R
\name{plot2}
\alias{plot2}
\title{Plot a pair of COMPASSResults}
\usage{
plot2(
  x,
  y,
  subset,
  threshold = 0.01,
  minimum_dof = 1,
  maximum_dof = Inf,
  must_express = NULL,
  row_annotation = NULL,
  palette = NA,
  show_rownames = FALSE,
  show_colnames = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{COMPASSResult}.}

\item{y}{An object of class \code{COMPASSResult}.}

\item{subset}{An \R expression, evaluated within the metadata, used to
determine which individuals should be kept.}

\item{threshold}{A numeric threshold for filtering under-expressed
categories. Any categories with mean score < \code{threshold} are
removed.}

\item{minimum_dof}{The minimum degree of functionality for the categories
to be plotted.}

\item{maximum_dof}{The maximum degree of functionality for the categories
to be plotted.}

\item{must_express}{A character vector of markers that should be included
in each subset plotted. For example, \code{must_express=c("TNFa & IFNg")}
says we include only subsets that are positive for both
\code{TNFa} or \code{IFNg}, while \code{must_express=c("TNFa", "IFNg")}
says we should keep subsets which are positive for either \code{TNFa} or
\code{IFNg}.}

\item{row_annotation}{A vector of names, pulled from the metadata, to be
used for row annotation.}

\item{palette}{The colour palette to be used.}

\item{show_rownames}{Boolean; if \code{TRUE} we display row names (ie,
the individual ids).}

\item{show_colnames}{Boolean; if \code{TRUE} we display column names
(ie, the column name associated with a cytokine; typically not needed)}

\item{...}{Optional arguments passed to \code{pheatmap}.}
}
\value{
The plot as a \code{grid} object (\code{grob}). It can be redrawn
with e.g. \code{grid::grid.draw()}.
}
\description{
This function can be used to visualize the mean probability of response --
that is, the probability that there is a difference in response between
samples subjected to the 'treatment' condition, and samples subjected
to the 'control' condition.
}
