% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-CogapsResult.R, R/methods-CogapsResult.R
\docType{methods}
\name{computeGeneGSProb}
\alias{computeGeneGSProb}
\alias{computeGeneGSProb,CogapsResult-method}
\title{compute gene probability}
\usage{
computeGeneGSProb(
  object,
  GStoGenes,
  numPerm = 500,
  Pw = rep(1, ncol(object@featureLoadings)),
  PwNull = FALSE
)

\S4method{computeGeneGSProb}{CogapsResult}(
  object,
  GStoGenes,
  numPerm = 500,
  Pw = rep(1, ncol(object@featureLoadings)),
  PwNull = FALSE
)
}
\arguments{
\item{object}{an object of type CogapsResult}

\item{GStoGenes}{data.frame or list with gene sets}

\item{numPerm}{number of permutations for null}

\item{Pw}{weight on genes}

\item{PwNull}{- logical indicating gene adjustment}
}
\value{
A vector of length GSGenes containing the p-values of set membership
for each gene containined in the set specified in GSGenes.
}
\description{
Computes the p-value for gene set membership using the CoGAPS-based
statistics developed in Fertig et al. (2012).  This statistic refines set
membership for each candidate gene in a set specified in \code{GSGenes} by
comparing the inferred activity of that gene to the average activity of the
set.
}
