% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rebin_peaks.R
\name{rebin_peaks}
\alias{rebin_peaks}
\title{Rebin peaks}
\usage{
rebin_peaks(
  peakfiles,
  genome_build,
  intensity_cols = c("total_signal", "qValue", "Peak Score", "score"),
  bin_size = 5000,
  keep_chr = NULL,
  sep = c(":", "-"),
  drop_empty_chr = FALSE,
  as_sparse = TRUE,
  workers = check_workers(),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{peakfiles}{A list of peak files as GRanges object and/or as paths to
BED files. If paths are provided, EpiCompare imports the file as GRanges
object. EpiCompare also accepts a list containing a mix of GRanges objects
and paths.Files must be listed and named using \code{list()}.
E.g. \code{list("name1"=file1, "name2"=file2)}. If no names are specified,
default file names will be assigned.}

\item{genome_build}{The build of **all** peak and reference files to 
calculate the correlation matrix on. If all peak and reference files are not 
of the same build use 
\link[EpiCompare]{liftover_grlist} to convert them all before running. Genome
build should be one of hg19, hg38, mm9, mm10.}

\item{intensity_cols}{Depending on which columns are present, this
value will be used to get quantiles and ultimately calculate the 
correlations:
\itemize{
 \item{"total_signal" : }{Used by the peak calling software 
 \href{https://github.com/FredHutch/SEACR}{SEACR}. 
 \emph{NOTE}: Another SEACR column (e.g. "max_signal") can be used 
 together or instead of "total_signal".}
 \item{"qValue"}{Used by the peak calling software 
 \href{https://github.com/macs3-project/MACS}{MACS2/3}. 
 Should contain the negative log of the p-values after multiple 
 testing correction.}
 \item{"Peak Score" : }{
 Used by the peak calling software
  \href{http://homer.ucsd.edu/homer/ngs/peaks.html}{HOMER}.}
}}

\item{bin_size}{Default of 100. Base-pair size of the bins created to measure
correlation. Use smaller value for higher resolution but longer run time and 
larger memory usage.}

\item{keep_chr}{Which chromosomes to keep.}

\item{sep}{Separator to be used after chromosome name (first item) and 
between start/end genomic coordinates (second item).}

\item{drop_empty_chr}{Drop chromosomes that are not present in any of the 
\code{peakfiles} (default: \code{FALSE}).}

\item{as_sparse}{Return the rebinned peaks as a sparse matrix
(default: \code{TRUE}), 
which is more efficiently stored than a dense matrix (\code{FALSE}).}

\item{workers}{Number of threads to parallelize across.}

\item{verbose}{Print messages.}

\item{...}{
  Arguments passed on to \code{\link[=bpplapply]{bpplapply}}
  \describe{
    \item{\code{apply_fun}}{Iterator function to use.}
    \item{\code{register_now}}{Register the cores now with
\link[BiocParallel]{register} (\code{TRUE}),
 or simply return the \code{BPPARAM object} (default: \code{FALSE}).}
    \item{\code{use_snowparam}}{Whether to use
\link[BiocParallel]{SnowParam} (default: \code{TRUE}) or
\link[BiocParallel]{MulticoreParam} (\code{FALSE})
 when parallelising across multiple \code{workers}.}
    \item{\code{progressbar}}{
    \code{logical(1)} Enable progress bar (based on plyr:::progress_text).
  }
    \item{\code{X}}{
    Any object for which methods \code{length}, \code{[}, and
    \code{[[} are implemented.
  }
    \item{\code{FUN}}{
    The \code{function} to be applied to each element of \code{X}.
  }
  }}
}
\value{
Binned peaks matrix
}
\description{
Standardise a list of peak files by rebinning them into fixd-width
 tiles across the genome.
}
\examples{
data("CnR_H3K27ac") 
data("CnT_H3K27ac")
peakfiles <- list(CnR_H3K27ac=CnR_H3K27ac, CnT_H3K27ac=CnT_H3K27ac) 

#increasing bin_size for speed
peakfiles_rebinned <- rebin_peaks(peakfiles = peakfiles,
                                  genome_build = "hg19",
                                  bin_size = 5000,
                                  workers = 1)
}
