% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_peakfile.R
\name{tidy_peakfile}
\alias{tidy_peakfile}
\title{Tidy peakfiles in GRanges}
\usage{
tidy_peakfile(peaklist, blacklist)
}
\arguments{
\item{peaklist}{A named list of peak files as GRanges object.
Objects must be named and listed using \code{list()}.
e.g. \code{list("name1"=file1, "name2"=file2)}
If not named, default names are assigned.}

\item{blacklist}{Peakfile specifying blacklisted regions as GRanges object.}
}
\value{
list of GRanges object
}
\description{
This function filters peak files by removing peaks in blacklisted regions
and in non-standard chromosomes. It also checks that the input list of
peakfiles is named. If no names are provided, default file names will be
used.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # example peakfile GRanges object
data("CnT_H3K27ac") # example peakfile GRanges object
data("hg19_blacklist") # blacklist region for hg19 genome

### Create Named Peaklist ###
peaklist <- list("encode"=encode_H3K27ac, "CnT"=CnT_H3K27ac)

### Run ###
peaklist_tidy <- tidy_peakfile(peaklist = peaklist,
                               blacklist = hg19_blacklist)

}
