% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content-plots.R
\name{calcGCContent}
\alias{calcGCContent}
\title{Calculate GC content over genomic ranges}
\usage{
calcGCContent(query, ref)
}
\arguments{
\item{query}{A GenomicRanges or GenomicRangesList object with query regions.}

\item{ref}{Reference genome BSgenome object.}
}
\value{
A numeric vector of list of vectors with the GC percentage of 
    the query regions.
}
\description{
Given a reference genome as a BSgenome object and some ranges on that
reference, this function will return a vector of the same length as the
granges object, with percent of Cs and Gs.
}
\examples{
\dontrun{
bsg = loadBSgenome('hg19')
gcvec = calcGCContent(vistaEnhancers, bsg)
}
}
