% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qthist.R
\name{plotQTHist}
\alias{plotQTHist}
\title{Plot quantile-trimmed histogram}
\usage{
plotQTHist(
  x,
  EndBarColor = "gray57",
  MiddleBarColor = "gray27",
  quantThresh = NULL,
  bins = NULL,
  indep = FALSE,
  numbers = FALSE
)
}
\arguments{
\item{x}{Data values to plot - vector or list of vectors}

\item{EndBarColor}{Color for the quantile bars on both ends of the graph
(optional)}

\item{MiddleBarColor}{Color for the bars in the middle of the graph
(optional)}

\item{quantThresh}{Quantile of data to be contained in each end bar (optional)
quantThresh values must be under .2, optimal size is under .1}

\item{bins}{The number of bins for the histogram to allocate data to.
(optional)}

\item{indep}{logical value which returns a list of plots that have had their
bins calculated independently; the normal version will plot them on the 
same x and y axis.}

\item{numbers}{a logical indicating whether the raw numbers should be 
displayed, rather than percentages (optional).}
}
\value{
A ggplot2 plot object
}
\description{
Given the results from \code{calcWidth}, plots a histogram with 
outliers trimmed.
}
\details{
x-axis breaks for the frequency calculations are based on the "divisions" 
results from helper function \code{calcDivisions}.
}
\examples{
regWidths = calcWidth(vistaEnhancers)
qtHist = plotQTHist(regWidths)
qtHist2 = plotQTHist(regWidths, quantThresh=0.1)
}
