% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hisatAlignment.R
\name{hisatAlignment}
\alias{hisatAlignment}
\title{hisatAlignment allows downloading and processing the fastq samples in a CSV file by using hisat2 aligner.}
\usage{
hisatAlignment(
  data,
  downloadRef = FALSE,
  downloadSamples = FALSE,
  createIndex = TRUE,
  BAMfiles = TRUE,
  SAMfiles = TRUE,
  countFiles = TRUE,
  referenceGenome = 38,
  customFA = "",
  customGTF = "",
  hisatParameters = "-p 8 --dta-cufflinks"
)
}
\arguments{
\item{data}{The ID of the variable which contains the samples. Our recommendation is to load this variable from a CSV file.}

\item{downloadRef}{A logical parameter that represents if the reference files will be downloaded or not.}

\item{downloadSamples}{A logical parameter that represents if the samples of the CSV file will be downloaded or not.}

\item{createIndex}{A logical parameter that represents if the index of the aligner would be created or not.}

\item{BAMfiles}{A logical parameter that represents if the you want the BAM files or not.}

\item{SAMfiles}{A logical parameter that represents if the you want the SAM files or not.}

\item{countFiles}{A logical parameter that represents if the you want the Count files or not.}

\item{referenceGenome}{This parameter allows choosing the reference genome that will be used for the alignment. The options are 37,38 or custom. The two first are human genomes, but with the third option you can choose any genome stored in the computer.}

\item{customFA}{The path to the custom FASTA file of the reference genome.}

\item{customGTF}{The path to the custom GTF file.}

\item{hisatParameters}{Parameter that allow to modify the default configuration for the Hisat2 aligner.}
}
\value{
Nothing to return.
}
\description{
This function allows downloading and processing the fastq samples in a CSV file by using hisat2 aligner. This funtion is used internally by \code{\link{rawAlignment}} but it can be used separatelly. Furthermore, the function can downloads the reference files required: FASTA Reference Genome and GTF file.
}
\examples{
# Due to the high computational cost, we strongly recommend it to see the offical documentation and the complete example included in this package:

dir <- system.file("extdata", package="KnowSeq")

#Using read.csv for NCBI/GEO files (read.csv2 for ArrayExpress files)
GSE74251csv <- read.csv(paste(dir,"/GSE74251.csv",sep = ""))

\dontrun{hisatAlignment(GSE74251csv,downloadRef=FALSE,downloadSamples=FALSE, createIndex = TRUE, BAMfiles = TRUE, SAMfiles = TRUE, countFiles = TRUE, referenceGenome = 38, customFA = "", customGTF = "")}
}
