% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf_test.R
\name{rf_test}
\alias{rf_test}
\title{rf_test allows assessing the final DEGs through a machine learning step by using Random Forest with a test dataset.}
\usage{
rf_test(train, labelsTrain, test, labelsTest, vars_selected, bestParameters)
}
\arguments{
\item{train}{The train parameter is an expression matrix or data.frame that contains the training dataset with the genes in the columns and the samples in the rows.}

\item{labelsTrain}{A vector or factor that contains the training labels for each of the samples in the train object.}

\item{test}{The test parameter is an expression matrix or data.frame that contains the test dataset with the genes in the columns and the samples in the rows.}

\item{labelsTest}{A vector or factor that contains the test labels for each of the samples in the test object.}

\item{vars_selected}{The genes selected to classify by using them. It can be the final DEGs extracted with the function \code{\link{DEGsExtraction}} or a custom vector of genes. Furthermore, the ranking achieved by \code{\link{featureSelection}} function can be used as input of this parameter.}

\item{bestParameters}{Best values for ntree and mtry parameters selected during the training phase.}
}
\value{
A list that contains four objects. The confusion matrix, the accuracy, the sensitibity and the specificity for each genes.
}
\description{
rf_test allows assessing the final DEGs through a machine learning step by using Random Forest with a test dataset.
}
\examples{
dir <- system.file("extdata", package="KnowSeq")
load(paste(dir,"/expressionExample.RData",sep = ""))

trainingMatrix <- t(DEGsMatrix)[c(1:4,6:9),]
trainingLabels <- labels[c(1:4,6:9)]
testMatrix <- t(DEGsMatrix)[c(5,10),]
testLabels <- labels[c(5,10)]
bestParameters <- 30
rf_test(trainingMatrix, trainingLabels, testMatrix, testLabels,rownames(DEGsMatrix)[1:10], bestParameters = bestParameters)
}
