% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{getSpecificQTL}
\alias{getSpecificQTL}
\title{getSpecificQTL}
\usage{
getSpecificQTL(meth.qtl.res, meth.qtl.background, type = "SNP")
}
\arguments{
\item{meth.qtl.res}{An object of type \code{\link{MethQTLResult-class}} for which specific QTLs are to be obtained.}

\item{meth.qtl.background}{The background set as a list of \code{\link{MethQTLResult-class}} objects.}

\item{type}{The type of annotation to be overlapped. Needs to be \code{'SNP'}, \code{'CpG'} or \code{'cor.block'}}
}
\value{
A \code{data.frame} of methQTL interactions sorted by the effect size.
}
\description{
This function returns the methQTL interactions specific for a result
}
\examples{
meth.qtl.res.1 <- loadMethQTLResult(system.file("extdata","MethQTLResult_chr18",package="MAGAR"))
meth.qtl.res.2 <- meth.qtl.res.1
res <- getSpecificQTL(meth.qtl.res.1,list(A=meth.qtl.res.1,B=meth.qtl.res.2),type="SNP")
}
\author{
Michael Scherer
}
