% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{qtlPlotSNPCpGInteraction}
\alias{qtlPlotSNPCpGInteraction}
\title{qtlPlotSNPCpGInteraction}
\usage{
qtlPlotSNPCpGInteraction(
  meth.qtl,
  cpg = NULL,
  snp = NULL,
  out.dir = NULL,
  meth.qtl.res = NULL,
  out.name = NULL
)
}
\arguments{
\item{meth.qtl}{An object of type \code{\link{MethQTLInput-class}} containing the methylation and genotype information
for the given CpG and the given SNP}

\item{cpg}{The CpG identifier as a character (e.g. cg12345678)}

\item{snp}{The SNP identifier as a character (e.g. rs12345678)}

\item{out.dir}{If specified, the plot is stored as a pdf in this directory}

\item{meth.qtl.res}{An optional argument of type \code{\link{MethQTLResult-class}} containing information on the results.
If either \code{cpg} or \code{snp} are NULL, this function sorts the results by increasing p-value and the uses the
best results for plotting.}

\item{out.name}{Optional name for the resulting plot}
}
\value{
An object of type \code{ggplot} comparing the CpG methylation states as boxplots across the different genotype states
}
\description{
Compares the methylation states of a given CpG for the genotype states availabe at the given SNP
}
\examples{
meth.qtl <- loadMethQTLInput(system.file("extdata","reduced_methQTL",package="MAGAR"))
qtlPlotSNPCpGInteraction(meth.qtl,cpg="cg19565884",snp="rs149871695")
}
\author{
Michael Scherer
}
