% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnNRI.R
\name{mbqnNRI}
\alias{mbqnNRI}
\title{Selective mean/median-balanced quantile normalization}
\usage{
mbqnNRI(
  x,
  FUN = "mean",
  na.rm = TRUE,
  method = NULL,
  low_thr = 0.5,
  index = NULL,
  offsetmatrix = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{x}{a data matrix, where rows represent features, e.g. of protein
abundance, and columns represent groups or samples, e.g. replicates,
treatments, or conditions.}

\item{FUN}{a function like mean, median (default), a user defined function,
or a numeric vector of weights with length \code{nrow(x)} to balance each
feature across samples. Functions can be parsed also as characters.
If FUN = NULL, features are not balanced, i.e. normal QN is used.}

\item{na.rm}{logical indicating to omit NAs in the
computation of feature mean.}

\item{method}{character specifying function for computation of quantile
normalization; "limma" (default) for \code{normalizeQuantiles()} from the
limma package or "preprocessCore" for \code{normalize.quantiles()} from the
preprocessCore package.}

\item{low_thr}{a value between [0 1]. Features with RI
frequency >=\code{low_thr} are considered as NRI/RI; default 0.5.}

\item{index}{an integer or a vector integers specifying the indices of
selected rows.}

\item{offsetmatrix}{logical indicating if offset matrix should be used
instead of offset vector specifying offset for each row}

\item{verbose}{logical indicating to print messages.}
}
\value{
Normalized \code{matrix}.
}
\description{
Quantile normalization of a data matrix where rank
invariant (RI)/nearly rank invariant (NRI) rows/features or other
user-selected rows are normalized by the mean/median-balanced quantile
normalization.
}
\details{
Selected rows and/or rows with rank invariance frequency
\code{>=threshold} are normalized with the mean/median-balanced quantile
normalization. Remaining rows are quantile normalized without mean balancing.
}
\examples{
## Quantile normalize a data matrix where
## nearly rank invariant (NRI) features are balanced
X <- matrix(c(5,2,3,NA,4,1,4,2,3,4,6,NA,1,3,1),ncol=3)
mbqnNRI(X, median,low_thr = 0.5) # Balance NRI features selected by threshold
mbqnNRI(X, median, index = c(1,2)) # Balance selected features
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\seealso{
\code{\link[=mbqn]{mbqn()}}, \code{\link[=mbqnGetNRIfeatures]{mbqnGetNRIfeatures()}}.
}
\author{
Ariane Schad
}
