% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbqnPlotAll.R
\name{mbqnPlotAll}
\alias{mbqnPlotAll}
\title{Plot RI/NRI feature frequencies and normalized/unnormalized features}
\usage{
mbqnPlotAll(
  x,
  FUN = NULL,
  low_thr = 0.5,
  show_nri_only = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{a data matrix. Rows represent features, e.g. protein abundances;
columns represent samples.}

\item{FUN}{a function like mean, median (default), a user defined function,
or a numeric vector of weights with length \code{nrow(x)} to balance each
feature across samples. Functions can be parsed also as characters.
If FUN = NULL, features are not balanced, i.e. normal QN is used.}

\item{low_thr}{a value between [0 1]. Features with RI
frequency >=\code{low_thr} are considered as NRI/RI; default 0.5.}

\item{show_nri_only}{logical indicating to display only the RI/NRI
detection graph.}

\item{verbose}{logical indicating to print messages.}

\item{...}{additional plot arguments passed to \code{mbqnBoxplot},
and \code{mbqnPlotRI}.}
}
\value{
A set of figures that display the detected RI/NRI features and a
list with elements:
\item{\code{p}}{a matrix with the rank invariance frequencies \code{ri.freq}
and the sample coverage \code{sample.coverage} for all detected
RI/NRI features}
\item{\code{max_p}}{maximum rank invariance frequency in percent}
\item{\code{ip}}{index of feature with maximum rank invariance frequency}
\item{\code{nri}}{table of the rank invariance frequencies in percent for
each NRI/RI feature}
\item{\code{var0_feature}}{indices of features with zero sample variance
after QN.}
}
\description{
Check data matrix for rank invariant (RI) and
nearly rank invariant (NRI) features/rows across samples and visualize
result for different normalizations.
}
\details{
Rank data and check if lower and upper intensity tails are
dominated by few features. Apply quantile
normalization without and with mean-balancing and check the standard
deviation of normalized features located in the tails.
}
\examples{
## Check data matrix for RI and NRI features
X <- matrix(c(5,2,3,NA,4,1,4,2,3,4,6,NA,1,3,1),ncol=3)
mbqnPlotAll(X, mean, low_thr = 0.5)
}
\references{
Brombacher, E., Schad, A., Kreutz, C. (2020). Tail-Robust
Quantile Normalization. BioRxiv.
}
\seealso{
\code{\link[=mbqnPlotRI]{mbqnPlotRI()}} and \code{\link[=mbqnBoxplot]{mbqnBoxplot()}} for the generation of figures,
and \code{\link[=mbqn]{mbqn()}} for normalization.
}
\author{
Ariane Schad
}
