% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{AdjacencyMatrix}
\alias{AdjacencyMatrix}
\title{Wrapper to create an instance of S4 class AdjacencyMatrix}
\usage{
AdjacencyMatrix(
  adj_l,
  rowData,
  type = c("structural", "statistical", "combine"),
  directed = c(TRUE, FALSE),
  thresholded = c(TRUE, FALSE)
)
}
\arguments{
\item{adj_l}{`list` of adjacency matrices}

\item{rowData}{`data.frame`, containing information on the features}

\item{type}{`character`, either `"structural"`, `"statistical"`, or 
`"combine"`}

\item{directed}{`logical`, if the adjacency matrix underlying the graph is
directed or undirected}

\item{thresholded}{`logical`, if the functions `rtCorrection` or `threshold`
were applied on the `structural` or `statistical` `AdjacencyMatrix` objects}
}
\value{
object of S4 class `AdjacencyMatrix`
}
\description{
The function `AdjacencyMatrix` will create an object of type 
`AdjacencyMatrix`.
}
\details{
`adj_l` is a list of adjacency matrices. The adjacency matrices have
identical dimensions and `dimnames` and each adjacency matrix has the 
same number of columns and rows and identical `rownames` and `colnames`.
`rowData` will be also used for the `colData` slot (since the `rownames` 
and `colnames` are identical).
}
\section{Accessors}{


- The `AdjacencyMatrix` class extends the
  [SummarizedExperiment::SummarizedExperiment] class and inherits
  all its accessors and replacement methods.

- The `type` accessor returns the `type` (`"structural"`, `"statistical"`, 
  `"combine"`) slot.
  
- The `directed` accessor returns the `directed` (`logical` of length 1)
  slot.
  
- The `thresholded` accessor returns the `thresholded` 
(`logical` of length 1) slot.
}

\examples{
binary <- matrix(0, ncol = 10, nrow = 10)
transformation <- matrix("", ncol = 10, nrow = 10)
mass_difference <- matrix("", ncol = 10, nrow = 10)

rownames(binary) <- rownames(transformation) <- rownames(mass_difference) <- paste("feature", 1:10)
colnames(binary) <- rownames(transformation) <- rownames(mass_difference) <- paste("feature", 1:10)

binary[5, 4] <- 1
transformation[5, 4] <- "glucose addition"
mass_difference[5, 4] <- "162"

## create adj_l and rowData
adj_l <- list(binary = binary, transformation = transformation, 
    mass_difference = mass_difference)
rowData <- DataFrame(features = rownames(binary),
    row.names = rownames(binary))

AdjacencyMatrix(adj_l = adj_l, rowData = rowData, type = "structural", 
    directed = TRUE, thresholded = FALSE)

}
\author{
Thomas Naake, \email{thomasnaake@googlemail.com}
}
