% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mz_summary.R
\name{mz_summary}
\alias{mz_summary}
\title{Create a summary from adjacency list containing mass differences}
\usage{
mz_summary(am, var = c("group", "formula"), filter = 0)
}
\arguments{
\item{am}{`AdjacencyMatrix`, a formal class of `AdjacencyMatrix` containing the 
mass differences, that have previously been generated by the function 
`structural`or `combine`}

\item{var}{`character` vector corresponding to `assayNames(am)`, the counts will be 
grouped according to `var`}

\item{filter}{`numeric`, leave empty or set to `0` if unfiltered data are 
required. Select a `numeric` as a threshold on counts of mz differences.
May be useful to visualize big data.}
}
\value{
`data.frame` containing the numbers of present mz differences and
corresponding name.
}
\description{
The function `mz_summary` creates a summary from the `AdjacencyMatrix`, 
containing mass differences. Individual mass differences are counted over 
all features. The input may be an `AdjacencyMatrix` object originating from 
the function `structural`, or `combine`. The parameter `filter` will define 
if data will be filtered above a certain threshold or not.
}
\details{
Summarizes the adjacency matrices containing mass difference values, 
i.e. either adjacency list from `structural`or `combine` may be used.
The default is filter = F, so the unfiltered summary will be returned. 
If filter is set to a `number`, e.g. 1000 only mz differences above 
this threshold will be displayed. 

The function can be applied for adjacency lists from `structural` and 
`combine`.
}
\examples{
data("x_test", package = "MetNet") 
transformation <- rbind(
    c("Monosaccharide (-H2O)", "C6H10O5", "162.0528234315"),
    c("Disaccharide (-H2O)", "C12H20O11", "340.1005614851"),
    c("Trisaccharide (-H2O)", "C18H30O15", "486.1584702945"))
transformation <- data.frame(group = transformation[, 1],
                                formula = transformation[, 2],
                                mass = as.numeric(transformation[, 3]))
am_struct <- structural(x_test, transformation, ppm = 5, 
    var = c("group", "mass", "formula"), directed = TRUE)
# unfiltered mz difference counts
mz_summary(am_struct)
# filtered mz difference counts 
mz_summary(am_struct, filter = 2)

}
\author{
Liesa Salzer, \email{liesa.salzer@helmholtz-muenchen.de} and
Thomas Naake, \email{thomasnaake@googlemail.com}
}
