% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperiment-helpers.R
\name{MultiAssayExperiment-helpers}
\alias{MultiAssayExperiment-helpers}
\alias{intersectRows}
\alias{intersectColumns}
\alias{mergeReplicates}
\alias{replicated}
\alias{complete.cases,MultiAssayExperiment-method}
\alias{isEmpty,MultiAssayExperiment-method}
\alias{replicated,MultiAssayExperiment-method}
\alias{anyReplicated}
\alias{anyReplicated,MultiAssayExperiment-method}
\alias{showReplicated}
\alias{showReplicated,MultiAssayExperiment-method}
\alias{replicates}
\alias{replicates,MultiAssayExperiment-method}
\alias{mergeReplicates,MultiAssayExperiment-method}
\alias{mergeReplicates,ANY-method}
\alias{longForm,MultiAssayExperiment-method}
\alias{longForm,ExperimentList-method}
\alias{longForm,ANY-method}
\alias{wideFormat}
\alias{hasRowRanges}
\alias{hasRowRanges,MultiAssayExperiment-method}
\alias{hasRowRanges,ExperimentList-method}
\alias{getWithColData}
\alias{renamePrimary}
\alias{renameColname}
\alias{splitAssays}
\alias{splitAssays,MultiAssayExperiment-method}
\alias{makeHitList}
\alias{makeMatchList}
\title{A group of helper functions for manipulating and cleaning a
MultiAssayExperiment}
\usage{
\S4method{complete.cases}{MultiAssayExperiment}(...)

\S4method{isEmpty}{MultiAssayExperiment}(x)

intersectRows(x)

intersectColumns(x)

replicated(x)

\S4method{replicated}{MultiAssayExperiment}(x)

anyReplicated(x)

\S4method{anyReplicated}{MultiAssayExperiment}(x)

showReplicated(x)

\S4method{showReplicated}{MultiAssayExperiment}(x)

replicates(x, ...)

\S4method{replicates}{MultiAssayExperiment}(x, ...)

mergeReplicates(x, replicates = list(), simplify = BiocGenerics::mean, ...)

\S4method{mergeReplicates}{MultiAssayExperiment}(
  x,
  replicates = replicated(x),
  simplify = BiocGenerics::mean,
  ...
)

\S4method{mergeReplicates}{ANY}(x, replicates = list(), simplify = BiocGenerics::mean, ...)

\S4method{longForm}{MultiAssayExperiment}(object, colDataCols = NULL, i = 1L, ...)

\S4method{longForm}{ExperimentList}(object, colDataCols, i = 1L, ...)

\S4method{longForm}{ANY}(object, colDataCols, i = 1L, ...)

wideFormat(
  object,
  colDataCols = NULL,
  check.names = TRUE,
  collapse = "_",
  i = 1L
)

hasRowRanges(x)

\S4method{hasRowRanges}{MultiAssayExperiment}(x)

\S4method{hasRowRanges}{ExperimentList}(x)

getWithColData(x, i, mode = c("append", "replace"), verbose = FALSE)

renamePrimary(x, value)

renameColname(x, i, value)

splitAssays(x, hitList)

\S4method{splitAssays}{MultiAssayExperiment}(x, hitList)

makeHitList(x, patternList)
}
\arguments{
\item{...}{Additional arguments. See details for more information.}

\item{x}{A MultiAssayExperiment or ExperimentList}

\item{replicates}{A list of \code{\link[IRanges:AtomicList-class]{LogicalList}}s
indicating multiple / duplicate entries for each biological unit per assay,
see \code{replicated} (default \code{replicated(x)}).}

\item{simplify}{A function for merging repeat measurements in experiments
as indicated by the \code{replicated} method for \code{MultiAssayExperiment}}

\item{object}{Any supported class object}

\item{colDataCols}{A \code{character}, \code{logical}, or \code{numeric}
index for \code{colData} columns to be included}

\item{i}{longForm: The i-th assay in
\code{SummarizedExperiment}-like objects. A vector input is
supported in the case that the \code{SummarizedExperiment} object(s) has more
than one assay (default 1L),
renameColname: Either a \code{numeric} or \code{character} index
indicating the assay whose colnames are to be renamed}

\item{check.names}{(logical default TRUE) Column names of the output
\code{DataFrame} will be checked for syntactic validity and made unique,
if necessary}

\item{collapse}{(character default "_") A single string delimiter for output
column names. In \code{wideFormat}, experiments and rownames (and when
replicate samples are present, colnames) are seperated by this delimiter}

\item{mode}{String indicating how \code{MultiAssayExperiment}
column-level metadata should be added to the
\code{SummarizedExperiment} \code{colData}.}

\item{verbose}{\code{logical(1)} Whether to \code{suppressMessages} on subsetting
operations in \code{getWithColData} (default FALSE)}

\item{value}{renamePrimary: A \code{character} vector of the same length as
the existing \code{rownames(colData)} to use for replacement,
renameColname: A \code{CharacterList} or \code{list} with matching
\code{lengths} to replace \code{colnames(x)}}

\item{hitList}{a named \code{list} or \code{List} of logical vectors that
indicate groupings in the assays}

\item{patternList}{a named \code{list} or \code{List} of atomic character
vectors that are the input to \code{grepl} for identifying groupings in
the assays}
}
\value{
See the itemized list in the description section for details.
}
\description{
A set of helper functions were created to help clean and
manipulate a MultiAssayExperiment object. \code{intersectRows} also works
for \code{ExperimentList} objects.
\itemize{
\item complete.cases: Returns a logical vector corresponding to 'colData'
rows that have data across all experiments
\item isEmpty: Returns a logical \code{TRUE} value for zero length
\code{MultiAssayExperiment} objects
\item intersectRows: Takes all common rows across experiments,
excludes experiments with empty rownames
\item intersectColumns: A wrapper for \code{complete.cases} to return a
\code{MultiAssayExperiment} with only those biological units that have
measurements across all experiments
\item replicated: Identifies, via logical vectors, \code{colname}s that
originate from a single biological unit within each assay
\item replicates: Provides the replicate \code{colname}s found with
the \code{replicated} function by their name, empty list if none
\item anyReplicated: Whether the assay has replicate measurements
\item showReplicated: Displays the actual columns that are replicated per
assay and biological unit, i.e., \code{primary} value (\code{colData}
rowname) in the \code{sampleMap}
\item mergeReplicates: A function that combines replicated / repeated
measurements across all experiments and is guided by the replicated
return value
\item longForm: A \code{MultiAssayExperiment} method that returns a small and
skinny \code{\link[S4Vectors:DataFrame-class]{DataFrame}}. The \code{colDataCols}
arguments allows the user to append \code{colData} columns to the data.
\item wideFormat: A function to reshape the data in a
\code{MultiAssayExperiment} to a "wide" format
\code{\link[S4Vectors:DataFrame-class]{DataFrame}}. Each row in the \code{DataFrame}
represents an observation (corresponding to an entry in the \code{colData}).
If replicates are present, their data will be appended at
the end of the corresponding row and will generate additional \code{NA} data.
It is recommended to remove or consolidate technical replicates with
\code{mergeReplicates}. Optional \code{colDataCols} can be added when the
original object is a \code{MultiAssayExperiment}.
\item hasRowRanges: A function that identifies ExperimentList elements
that have a
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{rowRanges}}
method
\item getWithColData: A convenience function for extracting an assay
and associated colData
\item renamePrimary: A convenience function to rename the primary
biological units as represented in the \code{rownames(colData)}
\item renameColname: A convenience function to rename the colnames
of a particular assay
}
}
\details{
The \code{replicated} function finds replicate measurements in each
assay and returns a list of \code{\link[IRanges:AtomicList-class]{LogicalList}}s.
Each element in a single \code{\link[IRanges:AtomicList-class]{LogicalList}} corresponds to
a biological or \emph{primary} unit as in the \code{sampleMap}. Below is a
small graphic for one particular biological unit in one assay, where the
logical vector corresponds to the number of measurements/samples in the
assay:
\preformatted{
 >      replicated(MultiAssayExperiment)
 (list str)       '-- $ AssayName
 (LogicalList str)      '-- [[ "Biological Unit" ]]
 Replicated if sum(...) > 1          '-- TRUE TRUE FALSE FALSE
}
\code{anyReplicated} determines if any of the assays have at least one
replicate. \emph{Note}. These methods are not available for the
\code{ExperimentList} class due to a missing \code{sampleMap} structure
(by design).
\code{showReplicated} returns a list of \code{\link[IRanges:AtomicList-class]{CharacterList}}s
where each element corresponds to the the biological or \emph{primary} units that
are replicated in that assay element. The values in the inner list are
the \code{colnames} in the assay that are technical replicates.

The \code{replicates} function (noun) returns the \code{colname}s
from the \code{sampleMap} that were identified as replicates. It returns a
list of \code{\link[IRanges:AtomicList-class]{CharacterList}}s for each assay present in
the \code{MultiAssayExperiment} and an inner entry for each biological unit that
has replicate observations in that assay.

The \code{mergeReplicates} function is a house-keeping method
for a \code{MultiAssayExperiment} where only \code{complete.cases} are
returned. This by-assay operation averages replicate measurements
(by default) and columns are aligned by the row order in \code{colData}.
Users can provide their own function for merging replicates with the
\code{simplify} functional argument. Additional inputs \code{...} are
sent to the 'simplify' function.

The \code{mergeReplicates} "ANY" method consolidates duplicate
measurements for rectangular data structures, returns object of the same
class (endomorphic). The ellipsis or \code{...} argument allows the
user to provide additional arguments to the \code{simplify} functional
argument.

The \code{longForm} "ANY" class method, works with classes such as
\code{\link[Biobase:class.ExpressionSet]{ExpressionSet}} and
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}} as
well as \code{matrix} to provide a consistent long and skinny
\code{\link[S4Vectors:DataFrame-class]{DataFrame}}.

The \code{hasRowRanges} method identifies assays that support
a \code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{rowRanges}}
method \emph{and} return a \code{\link[GenomicRanges:GRanges-class]{GRanges}} object.
}
\section{mergeReplicates}{

The \code{mergeReplicates} function makes use of the output from
\code{replicated} which will point out the duplicate measurements by
biological unit in the \code{MultiAssayExperiment}. This function will
return a \code{MultiAssayExperiment} with merged replicates. Additional
arguments can be provided to the simplify argument via the ellipsis
(\code{...}). For example, when replicates "TCGA-B" and "TCGA-A" are found in
the assay, the name of the first appearing replicate is taken (i.e., "B").
Note that a typical use case of merging replicates occurs when there are
multiple measurements on the \strong{same} sample (within the same assay)
and can therefore be averaged.
}

\section{longForm}{

The 'longForm' method takes data from the \code{\link{ExperimentList}}
in a \code{MultiAssayExperiment} and returns a uniform
\code{DataFrame}. The resulting DataFrame has columns indicating
primary, rowname, colname and value. This method can optionally include
columns of the MultiAssayExperiment colData named by \code{colDataCols} character
vector argument. (\code{MultiAssayExperiment} method only). The \code{i} argument
allows the user to specify the assay value for the
\code{SummarizedExperiment} assay function's \code{i} argument.
}

\section{wideFormat}{

The \code{wideFormat} function returns standardized wide \code{\link{DataFrame}}
where each row represents a biological unit as in the \code{colData}.
Depending on the data and setup, biological units can be patients, tumors,
specimens, etc. Metadata columns are
generated based on the names produced in the wide format
\code{DataFrame}. These can be accessed via the
\code{\link[S4Vectors:Vector-class]{mcols()}} function.
See the \code{wideFormat} section for description of the \code{colDataCols} and
\code{i} arguments.
}

\section{hasRowRanges}{

The \code{hasRowRanges} method identifies assays with associated ranged
row data by directly testing the method on the object. The result from the
test must be a \code{\link[GenomicRanges:GRanges-class]{GRanges}} class object to
satisfy the test.
}

\section{getWithColData}{

The \code{getWithColData} function allows the user to conveniently extract
a particular assay as indicated by the \strong{\code{i}} index argument. It
will also attempt to provide the
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{colData}}
along with the extracted object using the \verb{colData<-} replacement
method when possible. Typically, this method is available for
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
and \code{RaggedExperiment} classes.

The setting of \code{mode} determines how the \code{colData}
is added. If \code{mode="append"}, the \code{MultiAssayExperiment}
metadata is appended onto that of the \code{SummarizedExperiment}.
If any fields are duplicated by name, the values in the
\code{SummarizedExperiment} are retained, with a warning emitted if
the values are different.  For \code{mode="replace"}, the
\code{MultiAssayExperiment} metadata replaces that of the
\code{SummarizedExperiment}, while for \code{mode="none"},
no replacement or appending is performed.
}

\section{rename*}{

The \code{renamePrimary} function allows the user to conveniently change the
actual names of the primary biological units as seen in
\code{rownames(colData)}. \code{renameColname} allows the user to change the
names of a particular assay based on index \code{i}. \code{i} can either be
a single numeric or character value. See \verb{colnames<-} method for
renaming multiple colnames in a \code{MultiAssayExperiment}.
}

\section{splitAssays}{

The \code{splitAssays} method separates columns in each of the assays based
on the \code{hitList} input. The \code{hitList} can be generated using
the \code{makeHitList} helper function. To use the \code{makeHitList}
helper, the user should input a list of patterns that will match on the
column names of each assay. These matches should be mutually exclusive as
to avoid repetition of columns across assays. See the examples section.
}

\examples{

example(MultiAssayExperiment)

complete.cases(mae)

isEmpty(MultiAssayExperiment())


## renaming biological units (primary)

mae2 <- renamePrimary(mae, paste0("pt", 1:4))
colData(mae2)
sampleMap(mae2)


## renaming observational units (colname)

mae2 <- renameColname(mae, i = "Affy", paste0("ARRAY", 1:4))
colnames(mae2)
sampleMap(mae2)


patts <- list(
    normals = "TCGA-[A-Z0-9]{2}-[A-Z0-9]{4}-11",
    tumors = "TCGA-[A-Z0-9]{2}-[A-Z0-9]{4}-01"
)

data("miniACC")

hits <- makeHitList(miniACC, patts)

## only turmors present
splitAssays(miniACC, hits)

}
