% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Visualizations.R
\name{plotHeatmaply}
\alias{plotHeatmaply}
\title{Heatmap Visualization with Heatmaply}
\usage{
plotHeatmaply(
  fulldata,
  sel_prots = "all",
  heatmap_scale = "none",
  file = NULL,
  ...
)
}
\arguments{
\item{fulldata}{A \code{SummarizedExperiment} object containing the dataset.}

\item{sel_prots}{Character vector specifying selected features to include in
the heatmap or "all" to include all proteins.}

\item{heatmap_scale}{Character, indicating if and how the data should be
scaled. Possible values are "none", "row", or "column".}

\item{file}{Optional character string specifying the path to save the heatmap
plot. If NULL, the plot is rendered interactively.}

\item{...}{Arguments passed further to heatmaply function}
}
\value{
A plotly object if \code{file} is NULL. Otherwise, the heatmap is saved
to the specified file.
}
\description{
This function generates a heatmap for selected features across
comparisons using the heatmaply package.
It provides options for scaling and saving the plot to a file.
}
\examples{
data(liver_example)
plotHeatmaply(
    fulldata = liver_example, sel_prots = "all",
    heatmap_scale = "row"
)

}
