% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funcRIVER.R
\name{getFuncRvFeat}
\alias{getFuncRvFeat}
\title{Posterior probabilities of FR given G}
\usage{
getFuncRvFeat(Feat, logistic.model, lambda)
}
\arguments{
\item{Feat}{Genomic features (G)}

\item{logistic.model}{Logistic regression model with current estimate of beta}

\item{lambda}{Selected lambda}
}
\value{
probabilities of FR given genomic features, P(FR | G)
}
\description{
\code{getFuncRvFeat} computes posterior probabilities of FR (functionality of
        regulatory variant) given G (genomic features) and current estimate
        of beta (parameters between FR and G).
}
\examples{
dataInput <- getData(filename=system.file("extdata", "simulation_RIVER.gz",
        package = "RIVER"), ZscoreThrd=1.5)
Feat <- scale(t(Biobase::exprs(dataInput))) # genomic features (G)
Out <- as.vector(as.numeric(unlist(dataInput$Outlier))-1) # outlier status (E)
costs <- c(100, 10, 1, .1, .01, 1e-3, 1e-4)
logisticAllCV <- glmnet::cv.glmnet(Feat, Out, lambda=costs, family="binomial",
        alpha = 0, nfolds=10)
probFuncRvFeat <- getFuncRvFeat(Feat, logistic.model=logisticAllCV$glmnet.fit,
        lambda=logisticAllCV$lambda.min)

}
\seealso{
\code{\link{predict}}
}
\author{
Yungil Kim, \email{ipw012@gmail.com}
}
