% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recipeUpdate.R
\name{recipeUpdate}
\alias{recipeUpdate}
\title{recipeUpdate}
\usage{
recipeUpdate(
  cachePath = "ReUseDataRecipe",
  force = FALSE,
  remote = FALSE,
  repos = "rworkflow/ReUseDataRecipe"
)
}
\arguments{
\item{cachePath}{A character string specifying the name for the
\code{BiocFileCache} object to store the ReUseData recipes. Once
specified here, must use the same for \code{cachePath} argument in
\code{recipeSearch}, and \code{recipeLoad}. Default is "ReUseDataRecipe".}

\item{force}{Whether to remove existing and regenerate recipes
cache. Default is FALSE. Only use if any old recipes that have
been previously cached locally are updated remotely (on GitHub
\code{repos}).}

\item{remote}{Whether to download the data recipes directly from a
GitHub repository. Default is FALSE.}

\item{repos}{The GitHub repository containing data recipes that are
to be synced to local cache. Only works when
\code{remote=TRUE}. Default is "rworkflow/ReUseDataRecipe" GitHub
repository where public data recipes are saved, which might be
more up-to-date than the recipes contained in\code{ReUseData}
package. It can also be a private GitHub repository where users
save their own data recipes.}
}
\value{
a \code{recipeHub} object.
}
\description{
Function to sync and get the most updated and newly added data
recipes through the pubic "rworkflow/ReUseDataRecipe" GitHub
repository or user-specified private GitHub repository.
}
\examples{
## recipeUpdate()
## recipeUpdate(force=TRUE)
## recipeUpdate(force = TRUE, remote = TRUE)
}
