% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateDataset.R
\name{generateDataset}
\alias{generateDataset}
\title{Generate simulation data for different species}
\usage{
generateDataset(commonTags=15000, uniqueTags=c(1000, 3000),
                       unmapped=c(4000, 2000),group=c(1, 2),
                       libLimits=c(.9, 1.1)*1e6, empiricalDist=NULL,
                       genelength, randomRate=1/100,
                       pDifferential=.05, pUp=.5, foldDifference=2)
}
\arguments{
\item{commonTags}{The number of genes have the same expression level.}

\item{uniqueTags}{The number of genes only expressed in one species.}

\item{unmapped}{The number of genes only in one species.}

\item{group}{The number of species.}

\item{libLimits}{The limits for two species.}

\item{empiricalDist}{Define where to take random sample from (empirical
distribution OR random exponential), if NULL, the reads take from random
exponential.}

\item{genelength}{A vector of gene length for each gene of two species.}

\item{randomRate}{The parameter for exponential distribution.}

\item{pDifferential}{The propotion of differential expression genes.}

\item{pUp}{The probably for the reads in first species fold than the second
species.}

\item{foldDifference}{The fold for fold expression genes.}
}
\value{
list(.) A list of output, "DATAN" represents the read counts for the
first species, "DATAM" represents the read counts for the second species,
"trueFactors" represents the true scaling factor for data, "group" represents
the number of species, "libSizes" represents the library size for data,
"differentialInd" represents the ID for differential expression genes,
"commonInd" represents the ID for common expression genes.
}
\description{
To generate RNA-seq genes between different species.
}
\examples{
data(orthgenes)
orthgenes[, 6:9] <- round(orthgenes[, 6:9])
orthgenes1 <- orthgenes[!(is.na(orthgenes[,6])|is.na(orthgenes[,7])|
                       is.na(orthgenes[,8])|is.na(orthgenes[,9])), ]
sim_data <- generateDataset(commonTags=5000, uniqueTags=c(100, 300),
                            unmapped=c(400, 200),group=c(1, 2),
                            libLimits=c(.9, 1.1)*1e6,
                            empiricalDist=orthgenes1[, 6],
                            genelength=orthgenes1[, 2], randomRate=1/100,
                            pDifferential=.05, pUp=.5, foldDifference=2)
}
