/*
 * Decompiled with CFR 0.152.
 */
package base;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DebugLog {
    public static boolean DEBUG = true;
    public static final SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    public static final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.SSS");
    private static PrintWriter defaultLogger;
    private static String defaultLogFolder;

    public static void log(Object object) {
        String string = DebugLog.formatLogMessage(object);
        if (defaultLogFolder != null) {
            DebugLog.getDefaultLogger().println(string);
            DebugLog.getDefaultLogger().flush();
        }
        if (DEBUG) {
            System.out.println(string);
        }
    }

    public static void setDefaultLogFolder(String string) {
        defaultLogFolder = string;
    }

    public static String formatLogMessage(Object object) {
        Object object2;
        if (object instanceof Throwable) {
            object2 = (Throwable)object;
            ((Throwable)object2).printStackTrace();
        }
        object2 = Thread.currentThread().getStackTrace()[3].getClassName();
        String string = ((String)object2).substring(((String)object2).lastIndexOf(".") + 1);
        String string2 = Thread.currentThread().getStackTrace()[3].getMethodName();
        int n = Thread.currentThread().getStackTrace()[3].getLineNumber();
        return format.format(new Date()) + ":" + string + "." + string2 + "():" + n + "#" + Thread.currentThread().getName() + "\t" + object;
    }

    private static PrintWriter getDefaultLogger() {
        if (defaultLogger != null) {
            return defaultLogger;
        }
        try {
            String string = defaultLogFolder + "/" + format2.format(new Date()) + ".log";
            defaultLogger = new PrintWriter(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        return defaultLogger;
    }

    public static void verbose(String string) {
        DEBUG = Boolean.parseBoolean(string);
    }

    public static void verbose(boolean bl) {
        DEBUG = bl;
    }
}

