/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.FatalException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Sequence
implements Comparable<Sequence> {
    private static int[] ATCG_LOOKUP;
    private static char[] ATCG_LOOKUP_REVERSE;
    private static long[] ATCG_COMPLEMENT;
    private static long mask;
    private String input;
    private long value = -1L;
    private int length;

    public Sequence(String string) {
        this.input = string;
        this.length = string.length();
        if (string.length() > 32) {
            throw new RuntimeException("The length of input string[" + string + "] is longer than 31.");
        }
    }

    public Sequence(String string, int n, int n2) {
        this.length = n2;
        this.encode(string, n, n2);
    }

    public Sequence(long l, int n) {
        this.value = l;
        this.length = n;
    }

    private void encode(String string, int n, int n2) {
        long l = 0L;
        for (int i = n; i < n2 + n; ++i) {
            char c = string.charAt(i);
            int n3 = ATCG_LOOKUP[c];
            if (n3 == -1) {
                throw new RuntimeException("Invalid char:" + c);
            }
            l <<= 2;
            l |= (long)n3;
        }
        this.value = l;
    }

    public static long getCharCode(char c) {
        return ATCG_LOOKUP[c];
    }

    public static char getChar(int n) {
        return ATCG_LOOKUP_REVERSE[n];
    }

    public static boolean isValidSymbol(char c) {
        return ATCG_LOOKUP[c] != -1;
    }

    public static boolean isValidSymbolEnhanced(char c) {
        return c < '\u00ff' && Sequence.isValidSymbol(c);
    }

    private long encode() {
        if (this.value == -1L) {
            this.encode(this.input, 0, this.length);
        }
        return this.value;
    }

    public long getValue() {
        if (this.value == -1L) {
            this.encode();
        }
        return this.value;
    }

    public String getString() {
        if (this.input == null) {
            long l = this.value;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = this.length; i != 0; --i) {
                long l2 = l & 3L;
                stringBuffer.append(ATCG_LOOKUP_REVERSE[(int)l2]);
                l >>>= 2;
            }
            int n = this.length - stringBuffer.length();
            if (n != 0) {
                StringBuffer stringBuffer2 = new StringBuffer();
                while (n > 0) {
                    stringBuffer2.append(ATCG_LOOKUP_REVERSE[0]);
                    --n;
                }
                stringBuffer.reverse();
                stringBuffer2.append(stringBuffer);
                this.input = stringBuffer2.toString();
            } else {
                stringBuffer.reverse();
                this.input = stringBuffer.toString();
            }
        }
        return this.input;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public int compareTo(Sequence sequence) {
        long l;
        int n;
        long l2 = this.getValue();
        int n2 = (int)(l2 >> 30);
        if (n2 != (n = (int)((l = sequence.getValue()) >> 30))) {
            return n2 - n;
        }
        int n3 = (int)(l2 & mask);
        int n4 = (int)(l & mask);
        return n3 - n4;
    }

    public int hashCode() {
        Long l = this.getValue();
        if (l > Integer.MAX_VALUE) {
            return l.hashCode();
        }
        return (int)l.longValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        Sequence sequence = (Sequence)object;
        if (this.length != sequence.length) {
            System.out.println(this.length + " =?= " + sequence.length);
            System.out.println(this.getString() + " =?= " + sequence.getString());
            return false;
        }
        return this.getValue() == sequence.getValue();
    }

    public String toString() {
        return this.getString();
    }

    public Sequence getReverseComplement() {
        long l = this.getValue();
        int n = this.getLength();
        long l2 = 0L;
        for (int i = 0; i < n; ++i) {
            long l3 = l & 3L;
            l >>= 2;
            l2 <<= 2;
            l3 = ATCG_COMPLEMENT[(int)l3];
            l2 = l3 | l2;
        }
        Sequence sequence = new Sequence(l2, n);
        return sequence;
    }

    public static Map<String, Integer> getFeatures(Sequence sequence, byte by, Map<String, Integer> map) {
        if (by < 0) {
            return null;
        }
        if (map == null) {
            map = new HashMap<String, Integer>();
        }
        String string = sequence.getString();
        int n = sequence.getLength();
        for (int i = by + 1; i > 0; --i) {
            List<Sequence> list = Sequence.slidingWindow(string, 0, n, 0, true, i);
            for (Sequence sequence2 : list) {
                String string2 = sequence2.getString();
                Integer n2 = map.get(string2);
                int n3 = n2 == null ? 1 : n2 + 1;
                map.put(string2, n3);
            }
        }
        return map;
    }

    public static Map<String, Integer> generateFeaturesMatrix(byte n) {
        if (n < 0) {
            return null;
        }
        char[] cArray = ATCG_LOOKUP_REVERSE;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (char c : cArray) {
            arrayList.add(c + "");
        }
        for (int i = 1; i <= n; ++i) {
            int n2 = arrayList.size();
            for (int j = 0; j < n2; ++j) {
                for (char c : cArray) {
                    arrayList.add((String)arrayList.get(j) + c);
                }
            }
        }
        for (String string : arrayList) {
            hashMap.put(string, 0);
        }
        return hashMap;
    }

    public static List<Sequence> slidingWindow(String string, int n, int n2, int n3, boolean bl, int n4) {
        int n5;
        int n6 = n2 - n;
        int n7 = n4;
        int n8 = 0;
        for (n5 = 0; n5 < n4; ++n5) {
            n8 <<= 2;
            n8 |= 3;
        }
        n5 = n6 - n7 + 1 - n3;
        if (n5 <= 0) {
            String string2 = string.substring(n, n2);
            throw new FatalException("Raw input [" + string2 + "](length:" + n6 + ") not long enough for required " + n7 + "-mer counting. Offset=[" + n3 + "] UseSlidingWindow=[" + bl + "]");
        }
        if (!bl) {
            n5 = 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        LinkedList<Sequence> linkedList = new LinkedList<Sequence>();
        long l = 0L;
        for (int i = 0; i < n5; ++i) {
            if (i == 0) {
                linkedList.add(new Sequence(string, n + i + n3, n7));
                continue;
            }
            long l2 = linkedList.peekLast().getValue();
            l = Sequence.getCharCode(string.charAt(n + i + n7 - 1 + n3));
            long l3 = (l2 << 2 | l) & (long)n8;
            linkedList.add(new Sequence(l3, n7));
        }
        return linkedList;
    }

    public long reverseComplement() {
        long l = this.getValue();
        long l2 = 3L;
        long l3 = 0L;
        l3 |= (l ^= 0xFFFFFFFFFFFFFFFFL) & l2;
        for (int i = 1; i < this.length; ++i) {
            l3 <<= 2;
            l3 |= (l >>= 2) & l2;
        }
        return l3;
    }

    static {
        mask = Integer.MAX_VALUE;
        int n = 256;
        ATCG_LOOKUP = new int[n];
        for (int i = 0; i < n; ++i) {
            Sequence.ATCG_LOOKUP[i] = -1;
        }
        Sequence.ATCG_LOOKUP[97] = 0;
        Sequence.ATCG_LOOKUP[65] = 0;
        Sequence.ATCG_LOOKUP[99] = 1;
        Sequence.ATCG_LOOKUP[67] = 1;
        Sequence.ATCG_LOOKUP[103] = 2;
        Sequence.ATCG_LOOKUP[71] = 2;
        Sequence.ATCG_LOOKUP[116] = 3;
        Sequence.ATCG_LOOKUP[84] = 3;
        ATCG_LOOKUP_REVERSE = new char[]{'A', 'C', 'G', 'T'};
        ATCG_COMPLEMENT = new long[4];
        Sequence.ATCG_COMPLEMENT[0] = 3L;
        Sequence.ATCG_COMPLEMENT[1] = 2L;
        Sequence.ATCG_COMPLEMENT[2] = 1L;
        Sequence.ATCG_COMPLEMENT[3] = 0L;
    }
}

