/*
 * Decompiled with CFR 0.152.
 */
package test;

import base.ArraysMergerHeap;
import base.CountObject;
import base.DebugLog;
import base.MarkovModelInfo;
import base.RegexOption;
import base.Sequence;
import config.ExperimentReference;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import main.SELEX;
import main.SimpleKmerCount;

public class SELEXTest1 {
    public static String dataFolder = "./sample_data/";
    public static String configFolder = "./sample_config/";
    public static String tempFolder = "./tmp/";

    public static void main(String[] stringArray) {
        SELEXTest1.testKmerCounts();
    }

    public static void testGetRound0() {
        ExperimentReference experimentReference;
        ExperimentReference experimentReference2;
        int n;
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log(Arrays.toString(SELEX.showSamples()));
        SELEX.addSequenceInfo("seqX", configFolder + "/fastq_small1", "sampleX", 0, 16, "TGG", "CCAGCTG", "XXXXXXXX", "ZZZZ", "exdUbx.exdScr.0", "barcodeCCACGTC.v1");
        SELEX.exportConfigFile(configFolder + "/config-Seq99.xml");
        ExperimentReference experimentReference3 = SELEX.getExperimentReference("exdUbx.exdScr.L.2", "barcodeCCACGTC.v1.low", 2);
        ExperimentReference experimentReference4 = SELEX.getRound0(experimentReference3);
        if (experimentReference4 != null) {
            int n2 = 0;
            int n3 = 10;
            n = 10;
            SELEX.doMinimalCounting(experimentReference4, n, null, null, false, -1, false, -1, null);
            Object[] objectArray = SELEX.getKmerCount(experimentReference4, n, -1, n2, n3, null, null);
            DebugLog.log("=================COUNTS== " + SELEX.getSampleID(experimentReference4) + " ===============");
            SELEXTest1.print2DArray(objectArray);
        }
        if ((experimentReference2 = SELEX.getRound0(experimentReference = SELEX.getExperimentReference("seqX", "sampleX", 0))) != null) {
            n = 0;
            int n4 = 10;
            int n5 = 10;
            SELEX.doMinimalCounting(experimentReference2, n5, null, null, false, -1, false, -1, null);
            Object[] objectArray = SELEX.getKmerCount(experimentReference2, n5, -1, n, n4, null, null);
            DebugLog.log("=================COUNTS== " + SELEX.getSampleID(experimentReference2) + " ===============");
            SELEXTest1.print2DArray(objectArray);
        }
    }

    public static void testMarkov() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log(Arrays.toString(SELEX.showSamples()));
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        ExperimentReference experimentReference2 = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCAGCTG.v1", 0);
        ExperimentReference experimentReference3 = SELEX.getExperimentReference("exdUbx.exdScr.L.2", "barcodeCCACGTC.v1.low", 2);
        int n = 8;
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, n, null, "DIVISION|WITH_LEFT_FLANK");
        DebugLog.log(markovModelInfo.getMarkovR2());
        double d = SELEX.calculateInformationGain(experimentReference3, 12, markovModelInfo, null);
        DebugLog.log("IG:" + d);
        int n2 = 0;
        int n3 = 15;
        Object[] objectArray = SELEX.getKmerCount(experimentReference2, n, -1, n2, n3, markovModelInfo, null);
        DebugLog.log("=================COUNTS== Top ===============");
        SELEXTest1.print2DArray(objectArray);
        markovModelInfo = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, n, null, "DIVISION");
        DebugLog.log(markovModelInfo.getMarkovR2());
        d = SELEX.calculateInformationGain(experimentReference3, 12, markovModelInfo, null);
        DebugLog.log("IG:" + d);
        objectArray = SELEX.getKmerCount(experimentReference2, n, -1, n2, n3, markovModelInfo, null);
        DebugLog.log("=================COUNTS== Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    public static void testGetStatus() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log("========Samples==========");
        Object[] objectArray = SELEX.showSamples();
        SELEXTest1.print2DArray(objectArray);
        DebugLog.log("========getCountStats==========");
        objectArray = SELEX.getCountStats();
        SELEXTest1.print2DArray(objectArray);
    }

    public static void testSetConfig0() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log(Arrays.toString(SELEX.showSamples()));
    }

    public static void testGetProbability() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log(Arrays.toString(SELEX.showSamples()));
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        ExperimentReference experimentReference2 = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCAGCTG.v1", 0);
        ExperimentReference experimentReference3 = SELEX.getExperimentReference("exdUbx.exdScr.L.2", "barcodeCCACGTC.v1.low", 2);
        SELEX.kmax(experimentReference2);
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, 8, null, "DIVISION");
        DebugLog.log(markovModelInfo.getMarkovR2());
        double d = SELEX.calculateInformationGain(experimentReference3, 12, markovModelInfo, null);
        DebugLog.log(d);
        System.out.println(SELEX.getProbability("AAAAAAAAAA", markovModelInfo));
    }

    public static void testMarkovWithFilters() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        DebugLog.log(Arrays.toString(SELEX.showSamples()));
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        ExperimentReference experimentReference2 = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCAGCTG.v1", 0);
        ExperimentReference experimentReference3 = SELEX.getExperimentReference("exdUbx.exdScr.L.2", "barcodeCCACGTC.v1.low", 2);
        SELEX.kmax(experimentReference2);
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, 8, null, "DIVISION");
        DebugLog.log("================> R2:" + markovModelInfo.getMarkovR2());
        double d = SELEX.calculateInformationGain(experimentReference3, 12, markovModelInfo, null);
        DebugLog.log("================> IG:" + d);
        RegexOption regexOption = new RegexOption();
        regexOption.setVariableRegionExcludeRegex("^TTT");
        MarkovModelInfo markovModelInfo2 = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, 8, regexOption, "DIVISION");
        DebugLog.log("================> R2:" + markovModelInfo2.getMarkovR2());
        double d2 = SELEX.calculateInformationGain(experimentReference3, 12, markovModelInfo2, null);
        DebugLog.log("================> IG2:" + d2);
    }

    private static void testKmerCounts() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        int n = 16;
        int n2 = -1;
        int n3 = -1;
        int n4 = 10;
        SELEX.doMinimalCounting(experimentReference, n, null, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n3, n4, null, null);
        DebugLog.log("=================COUNTS==Top===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsMplex() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.mplex.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        int n = 8;
        int n2 = -1;
        int n3 = -1;
        int n4 = 10;
        SELEX.doMinimalCounting(experimentReference, n, null, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n3, n4, null, null);
        DebugLog.log("=================COUNTS==Top===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void print2DArray(Object[] objectArray) {
        int n = Array.getLength(objectArray[0]);
        for (int i = 0; i < n; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (Object object : objectArray) {
                stringBuffer.append(Array.get(object, i) + "\t");
            }
            DebugLog.log(stringBuffer.toString());
        }
    }

    private static void testKmerCountsReversedComplementAndProp() {
        SimpleKmerCount.includeReversed = true;
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference, 6, null, "DIVISION");
        DebugLog.log(markovModelInfo.getMarkovR2());
        float[] fArray = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        int[] nArray = null;
        long l = 0L;
        try {
            string2 = markovModelInfo.getMarkovObjPath();
            string3 = markovModelInfo.getMarkovCountsPath();
            n = markovModelInfo.getMarkovLength();
            l = markovModelInfo.getMarkovLengthTotalCount();
            DebugLog.log("Reading Markov Prob file:" + string2);
            FileInputStream fileInputStream = new FileInputStream(string2);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            fArray = (float[])objectInputStream.readObject();
            DebugLog.log("Reading Markov Count file:" + string3);
            ArraysMergerHeap.MinHeapNode minHeapNode = new ArraysMergerHeap.MinHeapNode(string3);
            CountObject countObject = null;
            nArray = new int[1 << 2 * n];
            while ((countObject = minHeapNode.peek()) != null) {
                Sequence sequence = countObject.getKey();
                nArray[(int)sequence.getValue()] = countObject.getCount();
                minHeapNode.pop();
            }
        }
        catch (Exception exception) {
            DebugLog.log(exception);
            throw new RuntimeException(exception);
        }
        long l2 = 0xFFFFFFFFL;
        DebugLog.log("size = " + l2);
        int n2 = 16;
        double d = 0.0;
        for (long i = 0L; i < l2; ++i) {
            Sequence sequence = new Sequence(i, n2);
            double d2 = SimpleKmerCount.getPredictedCount(n, l, sequence, nArray, fArray);
            d += d2;
            if (i % 20000000L != 0L) continue;
            DebugLog.log(i);
        }
        DebugLog.log("sum = " + d);
    }

    private static void testKmerCountsReversedComplementAndMarkov() {
        SimpleKmerCount.includeReversed = true;
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        ExperimentReference experimentReference2 = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCAGCTG.v1", 0);
        int n = 8;
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference, experimentReference2, 6, n, null, "DIVISION");
        DebugLog.log(markovModelInfo.getMarkovR2());
    }

    private static void testKmerCounts2() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        int n = 16;
        int n2 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        int n3 = -1;
        int n4 = 3;
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        n = 15;
        n4 = 4;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        n = 13;
        n3 = 20;
        n4 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCounts3() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        int n = 16;
        int n2 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        int n3 = -1;
        int n4 = 1;
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb1_list");
        n3 = 1000;
        n4 = 1;
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb2_list");
        n3 = -1;
        n4 = 3;
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb3_list");
    }

    private static void testKmerCounts4() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        int n = 20;
        int n2 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        int n3 = -1;
        int n4 = 1;
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb1_list");
        n3 = 1000;
        n4 = 1;
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb2_list");
        n3 = -1;
        n4 = 3;
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null, "/tmp/bb3_list");
    }

    private static void testKmerCountsWithOffset() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        int n = 8;
        int n2 = 8;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = null;
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, 20, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsWithFilters() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 16;
        int n2 = -1;
        int n3 = 30;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        RegexOption regexOption = new RegexOption();
        regexOption.setVariableRegionIncludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        regexOption.setVariableRegionExcludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsWithKmerFilters() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 16;
        int n2 = -1;
        int n3 = 100;
        int n4 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        RegexOption regexOption = new RegexOption();
        regexOption.setKmerIncludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        regexOption.setKmerExcludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsWithViewFilters() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 16;
        int n2 = -1;
        int n3 = -1;
        int n4 = 3;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        RegexOption regexOption = new RegexOption();
        regexOption.setViewIncludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        regexOption.setViewExcludeRegex("^A.{14}G");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        regexOption.getKmerIncludeOnly().add("GATTAAATATTTTTTG");
        regexOption.getKmerIncludeOnly().add("GATGTAGTCTTTTTTT");
        regexOption.getKmerIncludeOnly().add("GATATTAAGCCTATGT");
        regexOption.getKmerIncludeOnly().add("CGGTTAATCAATTTGT");
        regexOption.getKmerIncludeOnly().add("ATTTTATATGTTTTTT");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Kmer selection Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        regexOption.getViewIncludeOnly().add("GATTAAATATTTTTTG");
        regexOption.getViewIncludeOnly().add("GATGTAGTCTTTTTTT");
        regexOption.getViewIncludeOnly().add("GATATTAAGCCTATGT");
        regexOption.getViewIncludeOnly().add("CGGTTAATCAATTTGT");
        regexOption.getViewIncludeOnly().add("ATTTTATATGTTTTTT");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCounts20_1() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq100.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.L.2.xx", "xxx", 2);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 20;
        int n2 = -1;
        int n3 = 100;
        int n4 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCounts20_2() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq101.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("2013-1897_35", "R3_35", 3);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 16;
        int n2 = -1;
        int n3 = 100;
        int n4 = -1;
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, n, n2, n4, n3, null, null);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsWithGroupFilters() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        int n = 16;
        int n2 = -1;
        int n3 = 100;
        int n4 = 1;
        RegexOption regexOption = new RegexOption();
        regexOption.setVariableRegionIncludeRegex("^TGT");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        SELEX.getKmerCount(experimentReference, n, n2, n4, -1, null, regexOption, "/tmp/output");
        Object[] objectArray = null;
        DebugLog.log("=================COUNTS==Top ===============");
        regexOption = new RegexOption();
        n = 13;
        regexOption.setVariableRegionGroupRegex("^TGT([ACGT]{13})");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
        regexOption = new RegexOption();
        n = 5;
        regexOption.setVariableRegionGroupRegex("^TGT([ACGT]{5})");
        SELEX.doMinimalCounting(experimentReference, n, simpleKmerCount, null, false, n2, false, -1, regexOption);
        objectArray = SELEX.getKmerCount(experimentReference, n, n2, 0, n3, null, regexOption);
        DebugLog.log("=================COUNTS==Top ===============");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testKmerCountsPSFM() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        SELEX.doMinimalCounting(experimentReference, 2, simpleKmerCount, null, false, null, true, -1, null);
        Object[] objectArray = SELEX.getKmerCount(experimentReference, 2, -1, 1, -1, null, null);
        DebugLog.log("=================COUNTS=================");
        SELEXTest1.print2DArray(objectArray);
        Object[] objectArray2 = SELEX.getPSFM(experimentReference, 2, -1);
        DebugLog.log("=================PSFM=================");
        SELEXTest1.print2DArray(objectArray2);
    }

    private static void testFastqPSFM() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        SimpleKmerCount simpleKmerCount = new SimpleKmerCount();
        simpleKmerCount.initTraining(SELEX.getConfigReader(), experimentReference);
        simpleKmerCount.setTempFolder(tempFolder);
        SELEX.doMinimalCounting(experimentReference, 2, simpleKmerCount, null, false, null, true, -1, null);
        Object[] objectArray = SELEX.getFastqPSFM(experimentReference);
        DebugLog.log("=================FASTQ PSFM=================");
        SELEXTest1.print2DArray(objectArray);
        objectArray = SELEX.getSamplePSFM(experimentReference);
        DebugLog.log("=================Sample PSFM=================");
        SELEXTest1.print2DArray(objectArray);
    }

    private static void testSplitting() {
        SELEX.setWorkingDirectory(tempFolder);
        String string = configFolder + "/config-Seq1.xml";
        SELEX.loadConfigFile(string, dataFolder);
        string = configFolder + "/config-Seq2.xml";
        SELEX.loadConfigFile(string, dataFolder);
        ExperimentReference experimentReference = SELEX.getExperimentReference("exdUbx.exdScr.0", "barcodeCCACGTC.v1", 0);
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(0.5);
        arrayList.add(0.5);
        Object[] objectArray = SELEX.splitDataSet(experimentReference, "test", arrayList);
        SELEXTest1.print2DArray(objectArray);
        DebugLog.log("=================SAMPLES=================");
        Object[] objectArray2 = SELEX.showSamples();
        SELEXTest1.print2DArray(objectArray2);
        ExperimentReference experimentReference2 = SELEX.getExperimentReference("exdUbx.exdScr.0.test.1", "barcodeCCACGTC.v1.test.1", 0);
        ExperimentReference experimentReference3 = SELEX.getExperimentReference("exdUbx.exdScr.0.test.2", "barcodeCCACGTC.v1.test.2", 0);
        int n = SELEX.kmax(experimentReference3);
        MarkovModelInfo markovModelInfo = SELEX.trainMarkovModel(experimentReference2, experimentReference3, 5, n, null, null);
        DebugLog.log(markovModelInfo.getMarkovR2());
    }
}

