% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaRNAseq.R
\name{metaRNAseq}
\alias{metaRNAseq}
\title{metaRNAseq function}
\usage{
metaRNAseq(
  ind_deg,
  test_statistic = "fishercomb",
  BHth = 0.05,
  adjpval.t = 0.05,
  nrep = NULL,
  plot = FALSE
)
}
\arguments{
\item{ind_deg}{List of indipendent named DEG dataframes with p-values to be combined.}

\item{test_statistic}{p-value combination technique (inverse normal or Fisher):
\code{fishercomb}, \code{invnorm}.
By default: \code{fishercomb}.}

\item{BHth}{Benjamini Hochberg threshold.}

\item{adjpval.t}{threshold to represent as binary the Meta-Analysis output adjpval.}

\item{nrep}{Vector of numbers of replicates used in each study to calculate the previous one-sided p-values.}

\item{plot}{Logical. If TRUE plot histogram of pvalues.
By default, the False Discovery Rate is controlled at 0.05.}
}
\value{
A list with \code{DEindices} of DEG at the chosen Benjamini Hochberg threshold, and
\code{TestStatistic}, \code{rawpval}, \code{adjpval}, \code{binaryadjpval} vectors for differential expression in the meta-analysis.
}
\description{
Perform Meta-Analysis of RNA-Seq Data
}
\examples{
\dontrun{
# Deseq2 output samples
DGE1 <- data.frame(GeneID = c("DLK1", "EPCAM"),
                 Mean_CPM_T = c(5.92, 9.91),
                 Mean_CPM_C = c(0.04, 0.03),
                 log2FoldChange = c(10.22, 8.42),
                 lfcSE = c(0.80, 0.48),
                 stat = c(12.68, 17.69),
                 pvalue = c(7.30135e-37, 4.37011e-70),
                 padj = c(1.49936e-35, 1.12976e-67),
                 row.names = c("DLK1", "EPCAM"))
DGE2 <- data.frame(GeneID = c("DLK1", "EPCAM"),
                 Mean_CPM_T = c(3.92, 8.91),
                 Mean_CPM_C = c(0.04, 0.03),
                 log2FoldChange = c(7.22, 5.81),
                 lfcSE = c(0.80, 0.48),
                 stat = c(12.68, 17.69),
                 pvalue = c(7.30135e-37, 4.37011e-70),
                 padj = c(1.49936e-35, 1.12976e-67),
                 row.names = c("DLK1", "EPCAM"))
# input list
ind_deg <- list(DEG1_df = DGE1, DEG2_df = DGE2)
# perform meta-analysis
comb_pval_df <- metaRNAseq(ind_deg, test_statistic = "invnorm", BHth = 0.05, nrep = c(2,2))}
}
\seealso{
\code{\link{DGE}} for DGE analysis,
and \url{https://cran.r-project.org/web/packages/metaRNASeq/vignettes/metaRNASeq.pdf}
for metaRNASeq package info.

Other meta-analysis functions: 
\code{\link{combine_fisher_invnorm}()}
}
\concept{meta-analysis functions}
