% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniProt.ws-methods.R
\name{UniProt.ws-methods}
\alias{UniProt.ws-methods}
\alias{keytypes,UniProt.ws-method}
\alias{columns,UniProt.ws-method}
\alias{keys,UniProt.ws-method}
\alias{select,UniProt.ws-method}
\title{UniProt.ws methods from AnnotationDbi}
\usage{
\S4method{keytypes}{UniProt.ws}(x)

\S4method{columns}{UniProt.ws}(x)

\S4method{keys}{UniProt.ws}(x, keytype)

\S4method{select}{UniProt.ws}(x, keys, columns, keytype, ...)
}
\arguments{
\item{x}{a \code{UniProt.ws} object.}

\item{keytype}{\code{character(1)} The keytype that matches the keys used. For the
\code{select} methods, this is used to indicate the kind of ID being used with
the keys argument. For the \code{keys} method this is used to indicate which
kind of keys are desired from \code{keys}}

\item{keys}{\code{character()} the keys to select records for from the database.
All possible keys are returned by using the \code{keys} method.}

\item{columns}{\code{character()} The columns or kinds of things that can be
retrieved from the database.  As with \code{keys}, all possible columns are
returned by using the \code{columns} method.}

\item{...}{Additional arguments passed to lower level functions, mainly used
for the \code{to} input to \code{mapUniProt}.}
}
\value{
\itemize{
\item \code{keys},\code{columns},\code{keytypes}, return a character vector
of possible values
\itemize{
\item \code{select} returns a \code{data.frame}
}
}
}
\description{
Various methods from AnnotationDbi such as \code{select}, \code{columns},
\code{keys}, \code{keytypes}, and \code{species} are made available for UniProt.ws
objects.
}
\details{
In much the same way as an \code{AnnotationDb} object allows acces to
select for many other annotation packages, \code{UniProt.ws} is meant to allow
usage of \code{select} methods and other supporting methods to enable the easy
extraction of data from the UniProt web services.

\code{select}, \code{columns} and \code{keys} are used together to extract data via an
\code{UniProt.ws} object.

\code{columns} shows which kinds of data can be returned for the \code{UniProt.ws}
object.

\code{keytypes} allows the user to discover which keytypes can be passed in to
\code{select} or \code{keys} via the \code{keytype} argument.

\code{keys} returns keys for the database contained in the \code{UniProt.ws} object .
By default it will return the primary keys for the database, which are
UniProtKB keys, but if used with the \code{keytype} argument, it will return the
keys from that keytype.

\code{select} will retrieve the data as a data.frame based on parameters for
selected \code{keys} and \code{columns} and \code{keytype} arguments.
}
\section{Functions}{
\itemize{
\item \code{keytypes(UniProt.ws)}: Get keytypes for a UniProt.ws object

\item \code{columns(UniProt.ws)}: 

\item \code{keys(UniProt.ws)}: Get keys for a UniProt.ws object

\item \code{select(UniProt.ws)}: Select columns from keys

}}
\examples{
## Make a UniProt.ws object
up <- UniProt.ws(taxId=9606)

## list the possible key types
head(keytypes(up))

## list of possible columns
head(columns(up))

## list all possible keys of type entrez gene ID
egs <- keys(up, "GeneID")

## use select to extract some data
res <- select(
    x = up,
    keys = c("22627","22629"),
    columns = c("xref_pdb","xref_hgnc","sequence"),
    keytype = "GeneID"
)
res

univals <- c("A0A0C5B5G6", "A0A1B0GTW7", "A0JNW5", "A0JP26", "A0PK11")
res <- select(
    x = up,
    keys = univals,
    to = "Ensembl"
)
res

}
\seealso{
\linkS4class{UniProt.ws}
}
